/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.grid;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Args;
import org.ujorm.CompositeKey;
import org.ujorm.Key;
import org.ujorm.criterion.Criterion;
import org.ujorm.orm.ColumnWrapper;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Query;
import org.ujorm.orm.Session;
import org.ujorm.wicket.OrmSessionProvider;
import org.ujorm.wicket.component.grid.AbstractDataProvider;
import org.ujorm.wicket.component.grid.KeyColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UjoDataProvider<U extends OrmUjo>
extends AbstractDataProvider<U> {
    private static final long serialVersionUID = 1L;
    private OrmSessionProvider ormSession = new OrmSessionProvider();
    private boolean fetchDatabaseColumns = true;

    public UjoDataProvider(IModel<Criterion<U>> criterion) {
        this(criterion, null);
    }

    public UjoDataProvider(IModel<Criterion<U>> criterion, Key<? super U, ?> defaultSort) {
        super(criterion, defaultSort);
    }

    @Override
    public Iterator<U> iterator(long first, long count) {
        Args.isTrue((count <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"The argument '%s' have got limit %s but the current value is %s", (Object[])new Object[]{"count", Integer.MAX_VALUE, count});
        Query query = this.createQuery((Criterion)this.filter.getObject()).setLimit((int)count, first).addOrderBy(this.getSortKey());
        this.fetchDatabaseColumns(query);
        this.sortDatabaseQuery(query);
        return query.iterator();
    }

    @Override
    public long size() {
        if (this.size == null) {
            this.size = this.createQuery((Criterion)this.filter.getObject()).getCount();
        }
        return this.size;
    }

    protected Session getOrmSession() {
        return this.ormSession.getSession();
    }

    @Override
    public void detach() {
        this.ormSession.closeSession();
        this.size = null;
    }

    protected Query<U> createQuery(Criterion<U> criterion) {
        return this.getOrmSession().createQuery(criterion);
    }

    @Override
    protected boolean isSortingEnabled(Key<U, ?> column) throws IllegalArgumentException {
        return super.isSortingEnabled(column) && this.getOrmSession().getHandler().findColumnModel(column, false) != null;
    }

    protected void fetchDatabaseColumns(Query<U> query) {
        if (!this.fetchDatabaseColumns) {
            return;
        }
        if (this.getColumns().isEmpty()) {
            return;
        }
        if (query.getTableModel().isView()) {
            return;
        }
        OrmHandler handler = query.getSession().getHandler();
        ArrayList<Object> keys = new ArrayList<Object>(query.getColumns().size() + 3);
        for (ColumnWrapper columnWrapper : query.getColumns()) {
            keys.add(columnWrapper.getKey());
        }
        for (IColumn iColumn : this.getColumns()) {
            Key key;
            if (!(iColumn instanceof KeyColumn) || !(key = ((KeyColumn)iColumn).getKey()).isComposite() || ((CompositeKey)key).getCompositeCount() <= 1 || handler.findColumnModel(key) == null) continue;
            keys.add(key);
        }
        query.setColumns(true, keys.toArray(new Key[keys.size()]));
    }

    protected void sortDatabaseQuery(Query<U> query) {
        Key sortKey = this.getSortKey();
        if (sortKey != null) {
            query.addOrderBy(sortKey);
        }
    }

    public final boolean isFetchDatabaseColumns() {
        return this.fetchDatabaseColumns;
    }

    public void setFetchDatabaseColumns(boolean fetchDatabaseColumns) {
        this.fetchDatabaseColumns = fetchDatabaseColumns;
    }

    public static <T extends OrmUjo> UjoDataProvider<T> of(IModel<Criterion<T>> criterion, Key<? super T, ?> defaultSort) {
        return new UjoDataProvider<T>(criterion, defaultSort);
    }

    public static <T extends OrmUjo> UjoDataProvider<T> of(IModel<Criterion<T>> criterion) {
        return new UjoDataProvider<T>(criterion, null);
    }

    public static <T extends OrmUjo> UjoDataProvider<T> of(Criterion<T> criterion, Key<? super T, ?> defaultSort) {
        return new UjoDataProvider<T>(new Model(criterion), defaultSort);
    }

    public static <T extends OrmUjo> UjoDataProvider<T> of(Criterion<T> criterion) {
        return new UjoDataProvider(new Model(criterion), null);
    }
}

