/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.form.fields;

import java.util.List;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.core.KeyRing;
import org.ujorm.criterion.Criterion;
import org.ujorm.orm.ColumnWrapper;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Query;
import org.ujorm.wicket.OrmSessionProvider;
import org.ujorm.wicket.component.form.FieldEvent;
import org.ujorm.wicket.component.form.fields.Field;

public class ComboField<T extends Ujo>
extends Field<T> {
    private static final long serialVersionUID = 20130621L;
    private KeyRing<T> keys;
    private List<T> items;

    public <U extends Ujo> ComboField(Key<U, T> key, List<T> items, Key<T, ?> selectId, Key<T, ?> display) {
        super(key.getName(), key, null);
        this.keys = KeyRing.of((Key[])new Key[]{selectId, display});
        this.items = items;
    }

    public <U extends Ujo> ComboField(String componentId, Key<U, T> key, List<T> items, Key<T, ?> selectId, Key<T, ?> display, String cssClass) {
        super(componentId, key, cssClass);
        this.keys = KeyRing.of((Key[])new Key[]{selectId, display});
        this.items = items;
    }

    @Override
    protected FormComponent createInput(String componentId, IModel<T> model) {
        DropDownChoice result = new DropDownChoice(componentId, (IModel)new Model(), this.getItems(), new IChoiceRenderer<T>(){

            public Object getDisplayValue(T object) {
                return ComboField.this.getComboDisplayValue(object);
            }

            public String getIdValue(T object, int index) {
                return ComboField.this.getComboIdValue(object, index);
            }
        });
        result.setEnabled(this.isEnabled());
        result.setLabel(this.createLabelModel());
        result.setRequired(this.isRequired());
        result.setNullValid(!this.isRequired());
        return result;
    }

    protected Object getComboDisplayValue(T object) {
        return this.getKeyDisplay().of(object);
    }

    protected String getComboIdValue(T object, int index) {
        return String.valueOf(this.getKeyId().of(object));
    }

    public List<T> getItems() {
        return this.items;
    }

    public final Key<T, ?> getKeyId() {
        return this.keys.get(0);
    }

    public final Key<T, ?> getKeyDisplay() {
        return this.keys.get(1);
    }

    @Override
    public void onChange(String action) {
        this.addBehaviour(this.createChangeBehaviour(action, "onchange"));
    }

    @Override
    protected AjaxEventBehavior createChangeBehaviour(final String action, String jsEvent) {
        return new AjaxFormComponentUpdatingBehavior(jsEvent){

            protected void onUpdate(AjaxRequestTarget target) {
                ComboField.this.send((IEventSink)ComboField.this, Broadcast.BUBBLE, new FieldEvent(action, ComboField.this.key, target));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends OrmUjo> ComboField<T> of(Key<?, T> key, Criterion<T> items, Key<T, ?> display) {
        OrmSessionProvider session = new OrmSessionProvider();
        try {
            Query query = session.getSession().createQuery(items);
            if (display == null) {
                display = ((ColumnWrapper)query.getColumns().get(0)).getKey();
            }
            query.setColumns(true, new Key[]{display});
            query.orderBy(display);
            ComboField<T> comboField = ComboField.of(key, query, display);
            return comboField;
        }
        finally {
            session.closeSession();
        }
    }

    public static <T extends OrmUjo> ComboField<T> of(Key<?, T> key, Query<T> query, Key<T, ?> display) {
        Key idKey = query.getTableModel().getFirstPK().getKey();
        return new ComboField<T>(key, query.list(), idKey, display);
    }
}

