/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.form.fields;

import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.EnumChoiceRenderer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.wicket.component.form.fields.Field;
import org.ujorm.wicket.component.tools.ChoiceRendererNullable;

public class EnumField<T extends Enum<T>>
extends Field<T> {
    private static final long serialVersionUID = 20150121L;
    private static final boolean NULL_SUPPORT = false;
    private List<T> items;
    private IChoiceRenderer<T> renderer;

    public <U extends Ujo> EnumField(Key<U, T> key) {
        this(key, null);
    }

    public <U extends Ujo> EnumField(Key<U, T> key, String cssClass) {
        this(key.getName(), key, cssClass);
    }

    public <U extends Ujo> EnumField(String componentId, Key<U, T> key, String cssClass) {
        super(componentId, key, null);
        this.items = Arrays.asList(key.getType().getEnumConstants());
    }

    public IChoiceRenderer<T> getRenderer() {
        return this.renderer;
    }

    public void setRenderer(IChoiceRenderer<T> renderer) {
        this.renderer = renderer;
    }

    @Override
    protected FormComponent createInput(String componentId, IModel<T> model) {
        EnumChoiceRenderer aRenderer = this.renderer != null ? this.renderer : new EnumChoiceRenderer((Component)this);
        DropDownChoice result = new DropDownChoice<T>(componentId, model, this.getItems(), (IChoiceRenderer)aRenderer){

            protected String getNullKey() {
                return "value." + EnumField.super.getKey().getFullName() + ".null";
            }
        };
        result.setChoiceRenderer(new ChoiceRendererNullable((Component)this));
        result.setEnabled(this.isEnabled());
        result.setLabel(this.createLabelModel());
        return result;
    }

    protected Object getComboDisplayValue(T object) {
        return ((Enum)object).name();
    }

    protected String getComboIdValue(T object, int index) {
        return ((Enum)object).name();
    }

    public List<T> getItems() {
        return this.items;
    }
}

