/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.tabs;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ujorm.wicket.component.tabs.UjoTab;
import org.ujorm.wicket.component.tabs.UjoTabbedPanel;

public class UjoWizard<T extends UjoTab>
extends UjoTabbedPanel<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UjoWizard.class);
    private static final String TABS_CONTAINER_ID = "tabs-container";

    public UjoWizard(String id, List<T> tabs) {
        this(id, tabs, null);
    }

    public UjoWizard(String id, List<T> tabs, IModel<Integer> model) {
        super(id, tabs, model);
        WebMarkupContainer component = this.getTabContainer();
        if (component != null) {
            component.setVisibilityAllowed(false);
        } else {
            String msg = String.format("Component with the id '%s' is not found", TABS_CONTAINER_ID);
            LOGGER.warn(msg, (Throwable)new IllegalStateException(msg));
        }
    }

    protected WebMarkupContainer getTabContainer() {
        return (WebMarkupContainer)this.get(TABS_CONTAINER_ID);
    }

    @Nonnull
    public IModel<String> getNextTitleModel(boolean next) {
        int i = this.getSelectedTab() + (next ? 1 : -1);
        return i >= 0 && i < this.getTabSize() ? ((UjoTab)((Object)this.getTabs().get(i))).getTitle() : new Model(null);
    }

    @Nullable
    public final String getNextTitle(boolean next) {
        return (String)this.getNextTitleModel(next).getObject();
    }
}

