/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.form.fields;

import java.io.Serializable;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.ujorm.Key;
import org.ujorm.KeyList;
import org.ujorm.Ujo;
import org.ujorm.core.KeyRing;
import org.ujorm.core.UjoManager;
import org.ujorm.criterion.Criterion;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Query;
import org.ujorm.wicket.component.dialog.domestic.OfferDialogPane;
import org.ujorm.wicket.component.dialog.domestic.OfferModel;
import org.ujorm.wicket.component.form.Closeable;
import org.ujorm.wicket.component.form.fields.Field;

public class UjoField<U extends Ujo & Serializable>
extends Field<U>
implements Closeable<U> {
    private static final long serialVersionUID = 20150206L;
    private KeyRing<U> displayKey;
    private OfferDialogPane<U> offerDialog;
    private OfferModel<U> model;

    public <W extends Ujo> UjoField(String id, Key<W, U> key) {
        this(id, key, (OfferModel)null);
    }

    public <W extends Ujo> UjoField(@Nonnull String id, @Nonnull Key<W, U> key, @Nullable Key<U, ?> display) {
        this(id, key, (OfferModel)null);
        this.displayKey = display != null ? KeyRing.of(display) : null;
    }

    public <W extends Ujo> UjoField(String id, Key<W, U> key, @Nullable OfferModel<U> model) {
        super(id, key, null);
        this.model = model != null ? model : new OfferModel(key.getType());
        this.model.setClosable(this);
        Component[] componentArray = new Component[1];
        this.offerDialog = this.createDialog("offerDialog", this.model);
        componentArray[0] = this.offerDialog.getModalWindow();
        this.add(componentArray);
        this.addBehaviour(new AjaxEventBehavior("onclick"){

            protected void onEvent(AjaxRequestTarget target) {
                UjoField.this.showOfferDialog(target);
            }
        });
    }

    protected void showOfferDialog(AjaxRequestTarget target) {
        if (this.getInput().isEnableAllowed()) {
            this.model.setHighliting(this.createHighlitingCriterion());
            this.offerDialog.show(target, (IModel<String>)this.getInput().getLabel(), (IModel<U>)new Model((Serializable)((Object)"")));
        }
    }

    protected <V> Criterion<U> createHighlitingCriterion() {
        Key idKey = this.model.getId();
        Object idValue = idKey.of(this.getModelValue());
        Criterion result = idKey.whereEq(idValue);
        return result;
    }

    protected boolean isOrm() {
        return super.getKey().isTypeOf(OrmUjo.class);
    }

    public Key<U, ?> getDisplayKey() {
        Object result;
        if (this.displayKey != null) {
            result = this.displayKey.getFirstKey();
        } else {
            Key modelKey = this.model.getDisplay();
            result = modelKey != null ? modelKey : this.findDefaultDisplayKey();
            this.displayKey = KeyRing.of(result);
        }
        return result;
    }

    protected Key<U, ?> findDefaultDisplayKey() {
        Class type = this.getKey().getType();
        KeyList keyList = UjoManager.getInstance().readKeys(type);
        for (Key k : keyList) {
            if (!k.isTypeOf(String.class) || k.getName().toUpperCase(Locale.ENGLISH).indexOf("NAME") < 0) continue;
            return k;
        }
        for (Key k : keyList) {
            if (!k.isTypeOf(String.class)) continue;
            return k;
        }
        return keyList.getFirstKey();
    }

    @Override
    protected FormComponent createInput(String componentId, IModel<U> model) {
        Model<String> displayModel = new Model<String>(){

            public String getObject() {
                Ujo ujo = (Ujo)UjoField.this.getModelObject();
                Object result = ujo != null ? UjoField.this.getDisplayKey().of(ujo) : null;
                return result != null ? result.toString() : "";
            }
        };
        TextField result = new TextField(componentId, (IModel)displayModel, String.class);
        result.add(new Behavior[]{new AttributeModifier("readonly", (Serializable)((Object)"readonly"))});
        result.setEnabled(this.isEnabled());
        result.setLabel(this.createLabelModel());
        result.setRequired(this.isRequired());
        return result;
    }

    @Override
    public U getModelValue() {
        return (U)((Ujo)super.getModel().getObject());
    }

    @Override
    public void setModelValue(U value) {
        super.getModel().setObject(value);
    }

    public OfferDialogPane createDialog(String componentId, OfferModel model) {
        ModalWindow modalWindow = new ModalWindow(componentId, (IModel)Model.of((Serializable)((Object)"")));
        modalWindow.setCssClassName("w_blue");
        OfferDialogPane result = new OfferDialogPane(modalWindow, model);
        modalWindow.setInitialWidth(model.getDimension().width);
        modalWindow.setInitialHeight(model.getDimension().height);
        modalWindow.setTitle(model.getTitle());
        return result;
    }

    @Override
    public void closeDialog(AjaxRequestTarget target, U row) {
        this.offerDialog.close(target);
        if (row != null) {
            this.setModelValue(row);
            target.add(new Component[]{this});
        }
    }

    public static <T extends OrmUjo & Serializable> Field<T> of(Key<?, T> key, Query<T> query, @Nullable Key<T, ?> display) {
        return new UjoField<T>(key.getName(), key, display);
    }

    public static <U extends OrmUjo & Serializable> Field<U> of(Key<?, U> key, @Nullable Key<U, ?> display) {
        return new UjoField<U>(key.getName(), key, display);
    }

    public static <U extends OrmUjo & Serializable> Field<U> of(Key<?, U> key) {
        return new UjoField<U>(key.getName(), key, (OfferModel)null);
    }
}

