/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.toolbar;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.ujorm.Ujo;
import org.ujorm.wicket.UjoEvent;

public class InsertToolbar<U extends Ujo>
extends AbstractToolbar {
    private final Class<U> domainType;

    public InsertToolbar(DataTable dataTable, Class<U> domainType) {
        this(dataTable, domainType, "UPDATE");
    }

    public InsertToolbar(DataTable dataTable, Class<U> domainType, String actionName) {
        super(dataTable);
        super.setOutputMarkupPlaceholderTag(true);
        this.domainType = domainType;
        WebMarkupContainer td = new WebMarkupContainer("space");
        td.add(new Behavior[]{new AttributeModifier("colspan", (Serializable)Integer.valueOf(Math.max(1, dataTable.getColumns().size() - 1)))});
        this.add(new Component[]{td});
        AjaxLink link = this.createLink(actionName);
        this.add(new Component[]{link});
        link.add(new Component[]{this.createLabel("label")});
    }

    protected AjaxLink createLink(final String action) {
        return new AjaxLink("insert"){

            public void onClick(AjaxRequestTarget target) {
                InsertToolbar.this.onLinkClick(target, action);
            }
        };
    }

    protected void onLinkClick(AjaxRequestTarget target, String action) {
        this.send((IEventSink)this.getPage(), Broadcast.BREADTH, new UjoEvent<U>(action, this.newTypeInstance(), target));
    }

    protected Label createLabel(String id) {
        return new Label("label", (IModel)new ResourceModel("action.insert", "Create"));
    }

    protected U newTypeInstance() throws IllegalStateException {
        try {
            return (U)((Ujo)this.getDomainType().newInstance());
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't create instance of the " + this.getDomainType(), e);
        }
    }

    public Class<U> getDomainType() {
        return this.domainType;
    }
}

