/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.dialog.domestic;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.validator.ValidationError;
import org.ujorm.validator.ValidationException;
import org.ujorm.wicket.CssAppender;
import org.ujorm.wicket.UjoEvent;

public abstract class AbstractDialogPane<T>
extends GenericPanel<T> {
    private static final long serialVersionUID = 20130621L;
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(AbstractDialogPane.class);
    protected static final String BUTTON_PREFIX = "button.";
    protected static final String ACTION_BUTTON_ID = "actionButton";
    protected static final String CANCEL_BUTTON_ID = "cancelButton";
    protected static final String REPEATER_ID = "repeater";
    protected final Form<?> form;
    protected final ModalWindow modalWindow;
    protected final RepeatingView repeater;
    private String action = "";
    protected final boolean autoClose;
    protected IEventSink eventTarget;

    public AbstractDialogPane(ModalWindow modalWindow, IModel<? super T> model, boolean autoClose) {
        super(modalWindow.getContentId(), model);
        this.modalWindow = modalWindow;
        this.modalWindow.setContent((Component)this);
        this.autoClose = autoClose;
        this.setOutputMarkupPlaceholderTag(true);
        Component[] componentArray = new Component[1];
        this.form = new Form("dialogForm");
        componentArray[0] = this.form;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.repeater = new RepeatingView(REPEATER_ID);
        componentArray2[0] = this.repeater;
        this.form.add(componentArray2);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.form.setOutputMarkupId(true);
        this.form.add(new Component[]{this.createActionButton(ACTION_BUTTON_ID, "save")});
        this.form.add(new Component[]{this.createCancelButton(CANCEL_BUTTON_ID, "cancel")});
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public T getBaseModelObject() {
        return (T)this.getDefaultModelObject();
    }

    protected AjaxButton createActionButton(String id, String propertyName) {
        AjaxButton result = new AjaxButton(id, this.getButtonModel(propertyName), this.form){

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                try {
                    target.add(new Component[]{form});
                    UjoEvent uEvent = new UjoEvent(AbstractDialogPane.this.getAction(), false, AbstractDialogPane.this.getBaseModelObject(), target);
                    if (AbstractDialogPane.this.eventTarget != null) {
                        this.send(AbstractDialogPane.this.eventTarget, Broadcast.EXACT, uEvent);
                    } else {
                        this.send((IEventSink)this.getPage(), Broadcast.BREADTH, uEvent);
                    }
                    if (AbstractDialogPane.this.autoClose) {
                        AbstractDialogPane.this.modalWindow.close(target);
                    }
                }
                catch (Throwable e) {
                    AbstractDialogPane.this.setFeedback(e);
                }
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                target.add(new Component[]{form});
            }
        };
        result.add(new Behavior[]{new CssAppender("btn btn-primary")});
        this.form.setDefaultButton((IFormSubmittingComponent)result);
        return result;
    }

    protected AjaxButton createCancelButton(String id, String propertyName) {
        AjaxButton result = new AjaxButton(id, this.getButtonModel(propertyName), this.form){

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                AbstractDialogPane.this.closeForm(target, form);
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                AbstractDialogPane.this.closeForm(target, form);
            }
        };
        result.add(new Behavior[]{new CssAppender("btn")});
        return result;
    }

    protected void closeForm(AjaxRequestTarget target, Form<?> form) {
        form.clearInput();
        target.add(new Component[]{form});
        this.modalWindow.close(target);
    }

    protected void setFeedback(Throwable e) {
        e.getCause();
        if (e instanceof ValidationException) {
            ValidationError error = ((ValidationException)e).getError();
            String defaultMsg = error.getDefaultTemplate() + " [" + error.getLocalizationKey() + "]";
            String template = this.getString(error.getLocalizationKey(), null, defaultMsg);
            String msg = error.getMessage(template, this.getLocale());
            this.setFeedback((IModel<String>)Model.of((Serializable)((Object)msg)));
        } else {
            String msg = e.getClass().getSimpleName() + ": " + e.getMessage();
            this.setFeedback((IModel<String>)Model.of((Serializable)((Object)msg)));
            LOGGER.log(UjoLogger.ERROR, msg, e);
        }
    }

    protected abstract void setFeedback(IModel<String> var1);

    public void show(AjaxRequestTarget target, IModel<T> body) {
        this.show(target, null, body, null);
    }

    public void show(UjoEvent<T> event, IModel<String> title) {
        this.setAction(event.getAction());
        this.show(event.getTarget(), title, event.getUjoModel());
    }

    public void show(UjoEvent<T> event, IModel<String> title, String actionButtonProperty) {
        this.setAction(event.getAction());
        this.show(event.getTarget(), title, event.getUjoModel(), actionButtonProperty);
    }

    public void show(AjaxRequestTarget target, IModel<String> title, IModel<T> body) {
        this.show(target, title, body, null);
    }

    public void show(AjaxRequestTarget target, IModel<String> title, IModel<T> body, String actionButtonProperty) {
        this.setDefaultModel(body);
        this.setFeedback((IModel<String>)((IModel)null));
        if (title != null) {
            this.getModalWindow().setTitle(title);
        }
        if (actionButtonProperty != null) {
            this.form.get(ACTION_BUTTON_ID).setDefaultModel(this.getButtonModel(actionButtonProperty));
        }
        this.getModalWindow().show(target);
        target.add(new Component[]{this.form});
    }

    public ModalWindow getModalWindow() {
        return this.modalWindow;
    }

    public void close(AjaxRequestTarget target) {
        this.modalWindow.close(target);
    }

    public final void close(UjoEvent target) {
        this.close(target.getTarget());
    }

    protected IModel<String> getButtonModel(String propertyName) {
        return new ResourceModel(BUTTON_PREFIX + propertyName, propertyName);
    }

    public IEventSink getTarget() {
        return this.eventTarget;
    }

    public void setTarget(IEventSink target) {
        this.eventTarget = target;
    }
}

