/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.form.fields;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.attributes.ThrottlingSettings;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.SimpleFormComponentLabel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.validation.IValidator;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.Validator;
import org.ujorm.core.KeyRing;
import org.ujorm.validator.ValidatorUtils;
import org.ujorm.wicket.CssAppender;
import org.ujorm.wicket.component.form.FeedbackLabel;
import org.ujorm.wicket.component.form.FieldEvent;
import org.ujorm.wicket.component.form.UiValidator;
import org.ujorm.wicket.component.tools.LocalizedModel;

public class Field<T>
extends GenericPanel<T> {
    private static final long serialVersionUID = 20130621L;
    protected static final Duration DEFAULT_DELAY = Duration.milliseconds((long)300L);
    public static final String CSS_REQUIRED = "required";
    public static final String PROPERTY_PREFIX = "label.";
    private FormComponent<T> input;
    protected FeedbackLabel feedback;
    protected List<IValidator<? super T>> validators;
    protected String cssClass;
    protected KeyRing<?> key;
    protected List<Behavior> behaviors;
    private IModel<Boolean> visibleModel;

    public <U extends Ujo> Field(Key<U, T> key) {
        this(key.getName(), key, null);
    }

    public <U extends Ujo> Field(String componentId, Key<U, T> key, String cssClass) {
        super(componentId, (IModel)new Model());
        this.key = KeyRing.of(key);
        this.cssClass = cssClass;
    }

    protected final void onSuperInitialize() {
        super.onInitialize();
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Behavior[]{new CssAppender(this.getCssClass())});
        if (this.cssClass != null) {
            this.add(new Behavior[]{new CssAppender(this.cssClass)});
        }
        Component[] componentArray = new Component[1];
        this.input = this.createInput("input", this.getDefaultModel());
        componentArray[0] = this.input;
        this.add(componentArray);
        this.add(new Component[]{this.createLabel((Component)this.input)});
        Component[] componentArray2 = new Component[1];
        this.feedback = new FeedbackLabel("message", (Component)this.input, (IModel)null);
        componentArray2[0] = this.feedback;
        this.add(componentArray2);
    }

    protected void onConfigure() {
        super.onConfigure();
        if (this.validators != null) {
            for (IValidator<? super T> iValidator : this.validators) {
                this.input.add(iValidator);
                this.addMaxLength(this.input);
            }
            this.validators = null;
        }
        if (this.behaviors != null) {
            for (Behavior behavior : this.behaviors) {
                this.input.add(new Behavior[]{behavior});
            }
            this.behaviors = null;
        }
        if (this.visibleModel != null) {
            this.setVisible(Boolean.TRUE.equals(this.visibleModel.getObject()));
        }
    }

    protected FormComponent createInput(String componentId, IModel<T> model) {
        TextField result = new TextField(componentId, model, this.key.getFirstKey().getType());
        result.setEnabled(this.isEnabled());
        result.setLabel(this.createLabelModel());
        return result;
    }

    @Nonnull
    public List<IValidator<? super T>> getValidators() {
        if (this.validators != null) {
            return this.validators;
        }
        if (this.input != null) {
            return this.input.getValidators();
        }
        return Collections.emptyList();
    }

    public Field<T> addValidator(IValidator<T> validator) {
        if (this.validators == null) {
            this.validators = new ArrayList<IValidator<? super T>>();
        }
        this.validators.add(validator);
        return this;
    }

    public Field<T> addValidator(Validator<T> validator) {
        return this.addValidator(new UiValidator<T>(validator, this.key));
    }

    public T getModelValue() {
        return (T)this.input.getDefaultModelObject();
    }

    public void setModelValue(T value) {
        this.setDefaultModelObject(value);
        if (this.input != null) {
            this.input.getFeedbackMessages().clear();
        }
    }

    public Field<T> addBehaviour(AjaxEventBehavior behavior) {
        if (this.behaviors == null) {
            this.behaviors = new ArrayList<Behavior>();
        }
        this.behaviors.add((Behavior)behavior);
        return this;
    }

    public Field<T> addCssStyle(@Nonnull String cssStyle) {
        this.add(new Behavior[]{new CssAppender(cssStyle)});
        return this;
    }

    public FormComponent getInput() {
        return this.input;
    }

    protected void addMaxLength(FormComponent result) {
        if (this.key.getFirstKey().isTypeOf(String.class)) {
            int length = Integer.MAX_VALUE;
            for (IValidator<? super T> iValidator : this.validators) {
                if (!(iValidator instanceof UiValidator)) continue;
                int lh = ValidatorUtils.getMaxLength((Validator)((UiValidator)iValidator).getValidator());
                length = Math.min(lh, length);
            }
            if (length < Integer.MAX_VALUE) {
                result.add(new Behavior[]{new AttributeModifier("maxlength", (IModel)Model.of((Serializable)Integer.valueOf(length)))});
            }
        }
    }

    protected Component createLabel(Component inp) {
        SimpleFormComponentLabel result = new SimpleFormComponentLabel("label", this.input);
        if (this.isRequired()) {
            result.add(new Behavior[]{new CssAppender(CSS_REQUIRED)});
        }
        return result;
    }

    protected IModel createLabelModel() {
        Key<?, ?> nativeKey = this.getKey();
        ResourceModel labelModel = new ResourceModel(this.getResourceLabelKey(nativeKey), nativeKey.getName());
        return labelModel;
    }

    protected String getResourceLabelKey(Key<?, ?> key) {
        return PROPERTY_PREFIX + this.getKeyName();
    }

    protected boolean isRequired() {
        boolean result = this.validators instanceof UiValidator && ValidatorUtils.isMandatoryValidator((Validator)((UiValidator)((Object)this.validators)).getValidator());
        return result;
    }

    @Nullable
    public final Key<?, ?> getKey() {
        return this.key != null ? this.key.getFirstKey() : null;
    }

    public void setFeedbackMessage(IModel<String> message) {
        this.feedback.setFeedbackMessage(message);
    }

    public void clearFeedbackMessages() {
        if (this.input != null) {
            this.input.getFeedbackMessages().clear();
        }
    }

    protected String getCssClass() {
        return "control-group";
    }

    public IModel<Boolean> getVisibleModel() {
        return this.visibleModel;
    }

    public void setVisibleModel(IModel<Boolean> visibleModel) {
        this.visibleModel = visibleModel;
    }

    public boolean isEnabled() {
        if (super.isEnabled()) {
            FormComponent input = this.getInput();
            return input == null || input.isEnableAllowed();
        }
        return false;
    }

    public void onChange(String action) {
        this.addBehaviour(this.createChangeBehaviour(action, "keyup"));
        this.addBehaviour(this.createChangeBehaviour(action, "onchange"));
    }

    protected AjaxEventBehavior createChangeBehaviour(final String action, String jsEvent) {
        return new AjaxFormComponentUpdatingBehavior(jsEvent){

            protected void onUpdate(AjaxRequestTarget target) {
                Field.this.send((IEventSink)Field.this, Broadcast.BUBBLE, new FieldEvent(action, Field.this.key, target));
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.setThrottlingSettings(new ThrottlingSettings("thr2Id", DEFAULT_DELAY, true));
            }
        };
    }

    public AjaxEventBehavior addBehaviourOnBlur() {
        return new AjaxFormComponentUpdatingBehavior("onblur"){

            protected void onUpdate(AjaxRequestTarget t) {
            }
        };
    }

    public void requestFocus(@Nonnull AjaxRequestTarget target) {
        target.focusComponent((Component)this.getInput());
    }

    protected String getKeyName() {
        return this.getKeyName(this.getKey());
    }

    protected String getKeyName(Key<?, ?> key) {
        return LocalizedModel.getSimpleKeyName(key);
    }

    public String toString() {
        if (this.getKey() != null) {
            return this.getKeyName() + " for the input: " + this.getInput();
        }
        return String.valueOf(this.getInput());
    }
}

