/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.choice;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IModelComparator;
import org.apache.wicket.model.util.WildcardListModel;
import org.apache.wicket.util.lang.Args;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.core.KeyRing;

public class UjoDropDown<U extends Ujo>
extends DropDownChoice<U> {
    private final KeyRing<U> display;

    public UjoDropDown(String id, List<? extends U> choices, Key<U, ?> display, Key<U, ?> index) {
        this(id, choices, KeyRing.of((Key[])new Key[]{display, index}));
        Args.notNull(display, (String)"display");
        Args.notNull(index, (String)"index");
    }

    public UjoDropDown(String id, List<? extends U> choices, KeyRing<U> display) {
        this(id, (IModel<List<U>>)new WildcardListModel(choices), display);
    }

    public UjoDropDown(String id, IModel<List<? extends U>> choices, final KeyRing<U> display) {
        super(id, choices, new IChoiceRenderer<U>(){

            public Object getDisplayValue(U bo) {
                return display.getFirstKey().of(bo);
            }

            public String getIdValue(U bo, int index) {
                return "" + display.getLastKey().of(bo);
            }
        });
        this.display = display;
    }

    public IModelComparator getModelComparator() {
        return new IModelComparator(){

            public boolean compare(Component component, Object newObject) {
                if (UjoDropDown.this.display.getType().isInstance(newObject)) {
                    Ujo thisValue = (Ujo)component.getDefaultModelObject();
                    Key ID = UjoDropDown.this.display.getLastKey();
                    return thisValue != null && ID.equals(thisValue, ID.of((Ujo)newObject));
                }
                return UjoDropDown.super.getModelComparator().compare(component, newObject);
            }
        };
    }
}

