/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.form;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class FeedbackLabel
extends MultiLineLabel {
    private final Component input;
    private final IModel text;

    public FeedbackLabel(String id, Component input) {
        this(id, input, (IModel)null);
    }

    public FeedbackLabel(String id, Component component, String text) {
        this(id, component, (IModel)new Model((Serializable)((Object)text)));
    }

    public FeedbackLabel(String id, Component input, IModel iModel) {
        super(id);
        this.input = input;
        this.text = iModel;
        this.setOutputMarkupPlaceholderTag(true);
    }

    protected void onConfigure() {
        super.onConfigure();
        boolean visible = this.input.hasFeedbackMessage();
        super.setVisibilityAllowed(visible);
        if (visible) {
            if (this.text != null) {
                this.setDefaultModel(this.text);
            } else {
                this.setDefaultModel((IModel)new Model(this.input.getFeedbackMessages().first().getMessage()));
            }
        } else {
            this.setDefaultModel(null);
        }
    }

    public void setFeedbackMessage(IModel<String> message) {
        if (message != null) {
            this.input.getFeedbackMessages().add(new FeedbackMessage(this.input, (Serializable)message.getObject(), 0));
        } else {
            this.input.getFeedbackMessages().clear();
        }
    }

    public boolean isFeedbackMessage() {
        return !this.input.getFeedbackMessages().isEmpty();
    }
}

