/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.toolbar;

import javax.annotation.Nonnull;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.attributes.ThrottlingSettings;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.util.time.Duration;
import org.ujorm.Ujo;
import org.ujorm.criterion.Criterion;
import org.ujorm.wicket.UjoEvent;

public abstract class AbstractToolbar<U extends Ujo>
extends GenericPanel<U> {
    protected static final Duration DEFAULT_DELAY = Duration.milliseconds((long)400L);
    private IModel<Criterion<U>> criterionModel = Model.of();

    public AbstractToolbar(String id) {
        super(id);
    }

    public void onInitialize() {
        super.onInitialize();
        this.buildCriterion();
    }

    protected TextField createSearchFiled(String componentId) {
        return this.createSearchFiled(componentId, String.class, componentId);
    }

    protected TextField createSearchFiled(String componentId, Class<?> type) {
        return this.createSearchFiled(componentId, type, componentId);
    }

    protected final TextField createSearchFiled(String componentId, Class<?> type, String placeholderKey) {
        return this.createSearchFiled(componentId, type, (IModel<String>)new ResourceModel(placeholderKey, placeholderKey));
    }

    protected TextField createSearchFiled(String componentId, Class<?> type, IModel<String> placeholder) {
        TextField result = new TextField(componentId, (IModel)new Model(), type);
        result.add(new Behavior[]{new AttributeModifier("placeholder", placeholder)});
        result.setOutputMarkupId(true);
        result.add(new Behavior[]{this.createChangeBehavior((FormComponent)result)});
        return result;
    }

    public IModel<Criterion<U>> getCriterion() {
        return this.criterionModel;
    }

    protected abstract void buildCriterion();

    protected AjaxEventBehavior createChangeBehavior(FormComponent field) {
        return new AjaxFormComponentUpdatingBehavior("keyup"){

            protected void onUpdate(AjaxRequestTarget target) {
                AbstractToolbar.this.buildCriterion();
                AbstractToolbar.this.onUpdate(target);
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.setThrottlingSettings(new ThrottlingSettings("thrId", DEFAULT_DELAY, true));
            }
        };
    }

    protected void onUpdate(AjaxRequestTarget target) {
        this.send((IEventSink)this.getPage(), Broadcast.BREADTH, new UjoEvent(this.getDefaultActionName(), target));
    }

    protected String getDefaultActionName() {
        return "FILTER";
    }

    public void requestFocus(@Nonnull AjaxRequestTarget target) {
    }
}

