/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Args;

public class UjoEvent<U> {
    private final String action;
    private final boolean showDialog;
    private final U domain;
    private final AjaxRequestTarget target;

    public UjoEvent(String action, AjaxRequestTarget target) {
        this(action, null, target);
    }

    public UjoEvent(String action, U ujo, AjaxRequestTarget target) {
        this(action, true, ujo, target);
    }

    public UjoEvent(String action, boolean dialogRequest, U ujo, AjaxRequestTarget target) {
        this.action = (String)Args.notNull((Object)action, (String)"action");
        this.domain = ujo;
        this.showDialog = dialogRequest;
        this.target = target;
    }

    public U getDomain() {
        return this.domain;
    }

    public IModel<U> getUjoModel() {
        return new Model((Serializable)this.domain);
    }

    public AjaxRequestTarget getTarget() {
        return this.target;
    }

    public void addTarget(Component ... components) {
        this.target.add(components);
    }

    public String getAction() {
        return this.action;
    }

    public final boolean isAction(String action) {
        return action != null && this.action.hashCode() == action.hashCode() && this.action.equals(action);
    }

    public final boolean isAction(String ... actions) {
        for (String act : actions) {
            if (!this.isAction(act)) continue;
            return true;
        }
        return false;
    }

    public boolean showDialog() {
        return this.showDialog;
    }

    public String toString() {
        return "UjoEvent{ action=" + this.action + ", showDialog=" + this.showDialog + ", domain=" + this.domain + '}';
    }

    public static <T> UjoEvent<T> get(IEvent<?> argEvent) {
        Object payLoad = argEvent.getPayload();
        return payLoad instanceof UjoEvent ? (UjoEvent)payLoad : null;
    }
}

