/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.grid;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.core.KeyRing;
import org.ujorm.wicket.component.grid.KeyColumn;
import org.ujorm.wicket.component.tools.DateTimes;

public class KeyColumnDate<U extends Ujo>
extends KeyColumn<U, Date> {
    private static final long serialVersionUID = 1L;
    public static String DEFAULT_CSS_CLASS = "date";
    private final String localeDateFormatKey;

    public KeyColumnDate(KeyRing<U> key, KeyRing<U> keySortable) {
        this(key, keySortable, "locale.date.pattern");
    }

    public KeyColumnDate(KeyRing<U> key, KeyRing<U> keySortable, String localeDateFormatKey) {
        super(key, keySortable);
        this.localeDateFormatKey = localeDateFormatKey;
        this.setCssClass(DEFAULT_CSS_CLASS);
    }

    @Override
    protected Component createValueCoponent(String componentId, final IModel<?> valueModel, U ujo) {
        final Label result = new Label(componentId);
        result.setDefaultModel((IModel)new Model(){

            public Serializable getObject() {
                SimpleDateFormat form = new SimpleDateFormat(KeyColumnDate.this.getDatePattern((Component)result));
                return form.format((Date)valueModel.getObject());
            }
        });
        return result;
    }

    protected String getDatePattern(Component component) {
        return component.getLocalizer().getString(this.localeDateFormatKey, component, DateTimes.getDefaultPattern(this.localeDateFormatKey));
    }

    public static <U extends Ujo, T> KeyColumn<U, T> of(Key<U, T> key, boolean sorted, String cssClass) {
        return KeyColumnDate.of(key, sorted, cssClass, "locale.date.pattern");
    }

    public static <U extends Ujo, T> KeyColumn<U, T> of(Key<U, T> key, boolean sorted, String cssClass, String localeDateFormatKey) {
        KeyRing serializableKey = KeyRing.of(key);
        KeyColumnDate<U> result = new KeyColumnDate<U>(serializableKey, sorted ? serializableKey : null, localeDateFormatKey);
        result.setCssClass(cssClass);
        return result;
    }
}

