/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.tabs;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.ujorm.wicket.CssAppender;
import org.ujorm.wicket.component.link.MessageLink;
import org.ujorm.wicket.component.tabs.UjoTab;
import org.ujorm.wicket.component.tabs.UjoWizardPanel;

public class UjoWizardBar
extends GenericPanel<Object> {
    private RepeatingView repeater;
    private UjoWizardPanel<UjoTab> wizardPanel;

    public UjoWizardBar(String id, UjoWizardPanel<UjoTab> aWizard) {
        super(id);
        this.wizardPanel = aWizard;
        this.setOutputMarkupId(true);
        Component[] componentArray = new Component[1];
        this.repeater = new RepeatingView("repeaterItem");
        componentArray[0] = this.repeater;
        this.add(componentArray);
        List tabs = this.wizardPanel.getTabs();
        int i = 0;
        while (i < tabs.size()) {
            UjoTab tab = (UjoTab)((Object)tabs.get(i));
            final int ii = i++;
            MessageLink link = new MessageLink(this.repeater.newChildId(), tab.getTitle()){

                @Override
                protected void onClick(AjaxRequestTarget target) {
                    if (this.isActionAllowed()) {
                        UjoWizardBar.this.wizardPanel.selectTab(ii, target);
                        target.add(new Component[]{UjoWizardBar.this});
                        UjoWizardBar.this.onUpdate(target);
                    }
                }

                private boolean isActionAllowed() {
                    return this.isEnabled() && ii < UjoWizardBar.this.wizardPanel.getSelectedTab();
                }
            };
            link.setOutputMarkupId(true);
            link.add(new Behavior[]{new CssAppender(tab.getCssClass())});
            this.repeater.add(new Component[]{link});
        }
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        int selected = this.wizardPanel.getSelectedTab();
        int i = 0;
        for (Component item : this.repeater) {
            String cssClass = ((UjoTab)((Object)this.wizardPanel.getTabs().get(i))).getCssClass();
            item.add(new Behavior[]{new AttributeModifier(CssAppender.CSS_CLASS, (Serializable)((Object)cssClass))});
            if (i == selected) {
                item.add(new Behavior[]{new CssAppender("selected")});
            }
            if (i > selected) {
                item.add(new Behavior[]{new CssAppender("disabled")});
            }
            ++i;
        }
    }

    public UjoWizardPanel<UjoTab> getWizardPanel() {
        return this.wizardPanel;
    }

    protected void onUpdate(AjaxRequestTarget target) {
    }
}

