/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.grid;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Args;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.core.UjoComparator;
import org.ujorm.core.UjoIterator;
import org.ujorm.criterion.Criterion;
import org.ujorm.wicket.component.grid.AbstractDataProvider;

public class ListDataProvider<U extends Ujo>
extends AbstractDataProvider<U> {
    private static final long serialVersionUID = 1L;
    private List<U> dataRows;
    private List<U> filteredRows;
    private boolean sortRequest;

    public ListDataProvider(IModel<Criterion<U>> criterion) {
        this(criterion, null);
    }

    public ListDataProvider(IModel<Criterion<U>> filter, Key<? super U, ?> defaultSort) {
        super(filter, defaultSort);
        this.sortRequest = defaultSort != null;
    }

    public void setRows(List<? super U> dataRows) {
        this.dataRows = dataRows;
        this.clearBuffer();
    }

    @Nonnull
    public List<U> getRows() {
        return this.dataRows != null ? this.dataRows : Collections.emptyList();
    }

    @Nonnull
    protected List<U> getFileredRows() {
        if (this.filteredRows == null) {
            this.filteredRows = ((Criterion)this.filter.getObject()).evaluate(this.getRows());
        }
        return this.filteredRows;
    }

    @Override
    public Iterator<U> iterator(long first, long count) {
        Args.isTrue((count <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"The argument '%s' have got limit %s but the current value is %s", (Object[])new Object[]{"first", Integer.MAX_VALUE, first});
        Args.isTrue((count <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"The argument '%s' have got limit %s but the current value is %s", (Object[])new Object[]{"count", Integer.MAX_VALUE, count});
        List<U> rows = this.getFileredRows();
        if (this.sortRequest) {
            this.sortRows(rows);
        }
        int last = (int)Math.min(first + count, (long)rows.size());
        int frst = (int)Math.min(first, (long)last);
        return UjoIterator.of(rows.subList(frst, last));
    }

    protected void sortRows(List<U> rows) {
        UjoComparator.of(this.getSortKeys()).sort(rows);
    }

    @Override
    public long size() {
        if (this.size == null) {
            this.size = this.getFileredRows().size();
        }
        return this.size;
    }

    @Override
    public void detach() {
        this.clearBuffer();
    }

    protected void clearBuffer() {
        this.filteredRows = null;
        this.size = null;
    }

    @Override
    public boolean insertRow(@Nonnull U row) {
        this.clearBuffer();
        return this.getRows().add(row);
    }

    @Override
    public long deleteRow(@Nonnull Criterion<? super U> deleteCondition) {
        long result = 0L;
        List<U> rows = this.getRows();
        for (int i = rows.size() - 1; i >= 0; --i) {
            Ujo row = (Ujo)rows.get(i);
            if (!deleteCondition.evaluate(row)) continue;
            rows.remove(i);
            ++result;
        }
        this.clearBuffer();
        return result;
    }

    @Override
    public long updateRow(@Nonnull Criterion<? super U> updateCondition, @Nonnull U updatedRow) {
        long result = 0L;
        List<U> rows = this.getRows();
        for (int i = rows.size() - 1; i >= 0; --i) {
            Ujo row = (Ujo)rows.get(i);
            if (!updateCondition.evaluate(row)) continue;
            rows.set(i, updatedRow);
            ++result;
        }
        this.clearBuffer();
        return result;
    }

    public static <T extends Ujo> ListDataProvider<T> of(IModel<Criterion<T>> criterion, Key<? super T, ?> defaultSort) {
        return new ListDataProvider<T>(criterion, defaultSort);
    }

    public static <T extends Ujo> ListDataProvider<T> of(IModel<Criterion<T>> criterion) {
        return new ListDataProvider<T>(criterion, null);
    }

    public static <T extends Ujo> ListDataProvider<T> of(Criterion<T> criterion, Key<? super T, ?> defaultSort) {
        return new ListDataProvider<T>(new Model(criterion), defaultSort);
    }

    public static <T extends Ujo> ListDataProvider<T> of(Criterion<? super T> criterion) {
        return new ListDataProvider(new Model(criterion), null);
    }
}

