/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.grid;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.ujorm.Ujo;
import org.ujorm.wicket.UjoEvent;
import org.ujorm.wicket.component.grid.CommonAction;

public class CommonActionPanel<U extends Ujo>
extends GenericPanel<U> {
    protected final U row;

    public CommonActionPanel(String id, U row, CommonAction ... actions) {
        super(id);
        this.row = row;
        RepeatingView rvActions = new RepeatingView("actions");
        for (CommonAction action : actions) {
            rvActions.add(new Component[]{this.createLink(rvActions.newChildId(), action)});
        }
        this.add(new Component[]{rvActions});
    }

    protected final AjaxLink createLink(String id, final CommonAction<U> action) {
        AjaxLink result = new AjaxLink(id){

            public void onClick(AjaxRequestTarget target) {
                CommonActionPanel.this.onClick(target, action);
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisibilityAllowed(action.isVisible(CommonActionPanel.this.row));
            }
        };
        result.setOutputMarkupPlaceholderTag(true);
        result.add(new Component[]{new Label("label", action.getLabel())});
        return result;
    }

    protected void onClick(AjaxRequestTarget target, CommonAction<U> action) {
        this.send((IEventSink)this.getPage(), Broadcast.BREADTH, new UjoEvent<U>(action.getActionId(), this.row, target));
    }
}

