/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.form.fields;

import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.ui.form.datepicker.AjaxDatePicker;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.wicket.CssAppender;
import org.ujorm.wicket.component.form.fields.DateConverter;
import org.ujorm.wicket.component.form.fields.Field;
import org.ujorm.wicket.component.tools.DateTimes;

public class LocalDateField<T>
extends Field<T> {
    private static final long serialVersionUID = 20160615L;
    public static final String CSS_DATEPICKER = "datePickerComponent";

    public <U extends Ujo> LocalDateField(Key<U, T> key) {
        super(key.getName(), key, null);
    }

    public <U extends Ujo> LocalDateField(String componentId, Key<U, T> key, String cssClass) {
        super(componentId, key, cssClass);
    }

    @Override
    protected FormComponent createInput(String componentId, IModel<T> model) {
        AjaxDatePicker result = new AjaxDatePicker(componentId, model, this.getDatePattern(), this.createJQueryOptions());
        result.add(new Behavior[]{new CssAppender(this.getInputCssClass())});
        result.setEnabled(this.isEnabled());
        result.setLabel(this.createLabelModel());
        return result;
    }

    protected String getDatePattern() {
        String key = "locale.date.pattern";
        return this.getLocalizer().getString("locale.date.pattern", (Component)this, DateTimes.getDefaultPattern("locale.date.pattern"));
    }

    protected String getInputCssClass() {
        return CSS_DATEPICKER;
    }

    protected Options createJQueryOptions() {
        Options options = new Options();
        options.set("dateFormat", (Object)("'" + new DateConverter().toJQueryUIDateFormat(this.getDatePattern()) + "'"));
        return options;
    }
}

