/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.form.fields;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.wicket.Component;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.tools.Check;
import org.ujorm.wicket.component.form.fields.LocalDateField;
import org.ujorm.wicket.component.tools.DateTimes;

public class LocalDateTimeField<T>
extends LocalDateField<T> {
    private static final long serialVersionUID = 20170605L;
    public static final String CSS_DATEPICKER = "datePickerComponent";

    public <U extends Ujo> LocalDateTimeField(Key<U, T> key) {
        super(key.getName(), key, null);
    }

    public <U extends Ujo> LocalDateTimeField(String componentId, Key<U, T> key, String cssClass) {
        super(componentId, key, cssClass);
    }

    @Override
    protected String getDatePattern() {
        String key = "locale.datetime.pattern";
        return this.getLocalizer().getString("locale.datetime.pattern", (Component)this, DateTimes.getDefaultPattern("locale.datetime.pattern"));
    }

    @Override
    protected IConverter<?> createDateConverter() {
        return new IConverter<LocalDateTime>(){

            public LocalDateTime convertToObject(@Nullable String localDate, @Nullable Locale locale) throws ConversionException {
                return Check.hasLength((CharSequence)localDate) ? LocalDateTime.parse(localDate, this.getFormatter(locale)) : null;
            }

            public String convertToString(@Nullable LocalDateTime localDate, @Nullable Locale locale) {
                return localDate != null ? localDate.format(this.getFormatter(locale)) : "";
            }

            @Nonnull
            private DateTimeFormatter getFormatter(@Nullable Locale locale) {
                return DateTimeFormatter.ofPattern(LocalDateTimeField.this.getDatePattern(), locale);
            }
        };
    }
}

