/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.grid;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.core.KeyRing;
import org.ujorm.wicket.component.grid.KeyColumn;
import org.ujorm.wicket.component.tools.LocalizedModel;

public class KeyColumnEnum<U extends Ujo, T extends Enum<T>>
extends KeyColumn<U, T> {
    private static final long serialVersionUID = 1L;

    public KeyColumnEnum(KeyRing<U> key, KeyRing<U> keySortable) {
        super(key, keySortable);
    }

    @Override
    protected Component createValueCoponent(String componentId, final IModel<?> valueModel, U ujo) {
        final Label result = new Label(componentId);
        result.setDefaultModel((IModel)new Model(){

            public Serializable getObject() {
                Enum value = (Enum)valueModel.getObject();
                String resourceKey = KeyColumnEnum.this.resourceKey(value);
                String defaultValue = value != null ? value.name() : "";
                return result.getString(resourceKey, valueModel, defaultValue);
            }
        });
        return result;
    }

    protected String resourceKey(T value) {
        return value != null ? value.getClass().getSimpleName() + '.' + ((Enum)value).name() : "value." + LocalizedModel.getSimpleKeyName(this.getKey()) + ".null";
    }

    public static <U extends Ujo, T> KeyColumn<U, T> of(Key<U, T> key, boolean sorted, String cssClass) {
        KeyRing serializableKey = KeyRing.of(key);
        KeyColumnEnum<U, T> result = new KeyColumnEnum<U, T>(serializableKey, sorted ? serializableKey : null);
        result.setCssClass(cssClass);
        return result;
    }

    public static <U extends Ujo, T> KeyColumn<U, T> of(Key<U, T> key, Key<U, T> sort, String cssClass) {
        KeyColumnEnum<U, T> result = new KeyColumnEnum<U, T>(KeyRing.of(key), KeyRing.of(sort));
        result.setCssClass(cssClass);
        return result;
    }
}

