/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.tools;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.string.Strings;

public class ChoiceRendererNullable<T extends Enum<T>>
implements IChoiceRenderer<T> {
    private static final long serialVersionUID = 1L;
    protected static final String UNDEFINED_ITEM_KEY = "undefinedItem";
    private final Component resourceSource;

    public ChoiceRendererNullable() {
        this(null);
    }

    public ChoiceRendererNullable(Component resourceSource) {
        this.resourceSource = resourceSource;
    }

    public Object getDisplayValue(T item) throws NullPointerException {
        String key = this.resourceKey(item);
        String defaultValue = item != null ? ((Enum)item).name() : "-";
        String value = this.resourceSource != null ? this.resourceSource.getString(key, null, defaultValue) : Application.get().getResourceSettings().getLocalizer().getString(key, null, defaultValue);
        return this.postprocess(value);
    }

    protected String resourceKey(T item) {
        return item != null ? Classes.simpleName(((Enum)item).getDeclaringClass()) + '.' + ((Enum)item).name() : this.getUndefinedKey();
    }

    protected CharSequence postprocess(String value) {
        return Strings.escapeMarkup((CharSequence)value);
    }

    public String getIdValue(T item, int index) {
        return item != null ? ((Enum)item).name() : this.getUndefinedKey();
    }

    protected String getUndefinedKey() {
        return UNDEFINED_ITEM_KEY;
    }

    @Nullable
    public T getObject(String id, IModel<? extends List<? extends T>> choices) {
        List choiceList = (List)choices.getObject();
        int max = choiceList.size();
        for (int i = 0; i < max; ++i) {
            Enum choice = (Enum)choiceList.get(i);
            if (!this.getIdValue((T)choice, i).equals(id)) continue;
            return (T)choice;
        }
        return null;
    }
}

