/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.grid;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.ujorm.CompositeKey;
import org.ujorm.Key;
import org.ujorm.core.KeyRing;
import org.ujorm.criterion.Criterion;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Query;
import org.ujorm.orm.Session;
import org.ujorm.tools.Assert;
import org.ujorm.wicket.OrmSessionProvider;
import org.ujorm.wicket.component.grid.AbstractDataProvider;
import org.ujorm.wicket.component.grid.KeyColumn;

public class OrmDataProvider<U extends OrmUjo>
extends AbstractDataProvider<U> {
    private static final long serialVersionUID = 1L;
    List<KeyRing<U>> hiddenColumns = null;
    private OrmSessionProvider ormSession = new OrmSessionProvider();
    private boolean fetchDatabaseColumns = true;

    public OrmDataProvider(IModel<Criterion<U>> criterion) {
        this(criterion, null);
    }

    public OrmDataProvider(@Nonnull IModel<Criterion<U>> criterion, @Nonnull Key<? super U, ?> defaultSort) {
        super(criterion, defaultSort);
    }

    public void addHidden(@Nonnull Key<? super U, ?> column) {
        if (this.hiddenColumns == null) {
            this.hiddenColumns = new ArrayList<KeyRing<U>>();
        }
        this.hiddenColumns.add(KeyRing.of(column));
    }

    @Override
    @Nonnull
    public Iterator<U> iterator(long first, long count) {
        return this.iterator(first, count, (Criterion)this.filter.getObject());
    }

    @Nonnull
    protected Iterator<U> iterator(long first, long count, @Nonnull Criterion<U> crn) {
        Assert.isTrue((count <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object[])new Object[]{"The argument '{}' have got limit {} but the current value is {}", "count", Integer.MAX_VALUE, count});
        Query query = this.createQuery(crn).setLimit((int)count, first).addOrderBy(this.getSortKeys());
        this.fetchDatabaseColumns(query);
        this.sortDatabaseQuery(query);
        return query.iterator();
    }

    @Override
    public long size() {
        if (this.size == null) {
            this.size = this.createQuery((Criterion)this.filter.getObject()).getCount();
        }
        return this.size;
    }

    @Nonnull
    protected Session getOrmSession() {
        return this.ormSession.getSession();
    }

    @Override
    public void detach() {
        this.ormSession.closeSession();
        this.size = null;
    }

    @Nonnull
    protected Query<U> createQuery(@Nonnull Criterion<U> criterion) {
        return this.getOrmSession().createQuery(criterion);
    }

    @Override
    protected boolean isSortingEnabled(@Nonnull Key<U, ?> column) throws IllegalArgumentException {
        return super.isSortingEnabled(column) && this.getOrmSession().getHandler().findColumnModel(column, false) != null;
    }

    protected void fetchDatabaseColumns(@Nonnull Query<U> query) {
        if (this.getColumns().isEmpty()) {
            return;
        }
        if (query.getTableModel().isView()) {
            return;
        }
        if (this.hiddenColumns != null) {
            for (KeyRing<U> hiddenKey : this.hiddenColumns) {
                query.addColumn(hiddenKey.getFirstKey());
            }
        }
        if (!this.fetchDatabaseColumns) {
            return;
        }
        OrmHandler handler = query.getSession().getHandler();
        for (IColumn iColumn : this.getColumns()) {
            Key key;
            if (!(iColumn instanceof KeyColumn) || !(key = ((KeyColumn)iColumn).getKey()).isComposite() || ((CompositeKey)key).getKeyCount() <= 1 || handler.findColumnModel(key) == null) continue;
            query.addColumn(key);
        }
    }

    public List<KeyRing<U>> getHiddenColumns() {
        return this.hiddenColumns;
    }

    protected void sortDatabaseQuery(Query<U> query) {
        Key sortKey = this.getSortKey();
        if (sortKey != null) {
            query.addOrderBy(sortKey);
        }
    }

    public final boolean isFetchDatabaseColumns() {
        return this.fetchDatabaseColumns;
    }

    public void setFetchDatabaseColumns(boolean fetchDatabaseColumns) {
        this.fetchDatabaseColumns = fetchDatabaseColumns;
    }

    public void clearCache() {
    }

    public static <T extends OrmUjo> OrmDataProvider<T> of(@Nonnull IModel<Criterion<T>> criterion, @Nonnull Key<? super T, ?> defaultSort) {
        return new OrmDataProvider<T>(criterion, defaultSort);
    }

    public static <T extends OrmUjo> OrmDataProvider<T> of(@Nonnull IModel<Criterion<T>> criterion) {
        return new OrmDataProvider<T>(criterion, null);
    }

    public static <T extends OrmUjo> OrmDataProvider<T> of(@Nonnull Criterion<T> criterion, @Nonnull Key<? super T, ?> defaultSort) {
        return new OrmDataProvider<T>(new Model(criterion), defaultSort);
    }

    public static <T extends OrmUjo> OrmDataProvider<T> of(@Nonnull Criterion<T> criterion) {
        return new OrmDataProvider(new Model(criterion), null);
    }
}

