/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket;

import javax.annotation.Nonnull;
import org.apache.wicket.model.IModel;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.core.KeyRing;

public class MultiKeyModel<U extends Ujo>
implements IModel<CharSequence> {
    private static final long serialVersionUID = 1L;
    private final IModel<U> domainModel;
    private final String separator;
    private final KeyRing<U> keyRing;

    protected MultiKeyModel(IModel<U> domainModel, String separator, Key<U, ?> ... keys) {
        this.domainModel = domainModel;
        this.separator = separator;
        this.keyRing = KeyRing.of(keys);
    }

    public String toString() {
        return this.getObject().toString();
    }

    public final Key<U, ?> getKeyRing() {
        return (Key)this.keyRing;
    }

    public CharSequence getObject() {
        StringBuilder result = new StringBuilder();
        Ujo domain = (Ujo)this.domainModel.getObject();
        int max = this.keyRing.size();
        for (int i = 0; i < max; ++i) {
            if (i > 0) {
                result.append(this.separator);
            }
            result.append(this.format(this.keyRing.getValue(domain, i)));
        }
        return result;
    }

    @Nonnull
    protected String format(@Nonnull Object value) {
        return value != null ? value.toString() : "";
    }

    public void setObject(CharSequence object) {
        throw new UnsupportedOperationException(String.valueOf(object));
    }

    public Class<? super U> getBaseClass() {
        return this.keyRing.getType();
    }

    public void detach() {
    }

    public static <UJO extends Ujo, T> MultiKeyModel<UJO> of(@Nonnull IModel<UJO> domainModel, Key<UJO, ?> ... keys) {
        return new MultiKeyModel<UJO>(domainModel, " ", keys);
    }

    public static <UJO extends Ujo, T> MultiKeyModel<UJO> of(@Nonnull IModel<UJO> domainModel, @Nonnull String separator, Key<UJO, ?> ... keys) {
        return new MultiKeyModel<UJO>(domainModel, separator, keys);
    }
}

