/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.tabs;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.ujorm.core.IllegalUjormException;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.tools.msg.MsgFormatter;
import org.ujorm.wicket.component.tabs.UjoTab;
import org.ujorm.wicket.component.tabs.UjoTabbedPanel;

public class UjoWizardPanel<T extends UjoTab>
extends UjoTabbedPanel<T> {
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(UjoWizardPanel.class);
    private static final String TABS_BAR_ID = "tabs-container";

    public UjoWizardPanel(String id, List<T> tabs) {
        this(id, tabs, null);
    }

    public UjoWizardPanel(String id, List<T> tabs, IModel<Integer> model) {
        super(id, tabs, model);
        WebMarkupContainer component = this.getTabBar();
        if (component != null) {
            component.setOutputMarkupId(false);
            component.setVisibilityAllowed(false);
        } else {
            String msg = MsgFormatter.format((String)"Component with the id '{}' is not found", (Object[])new Object[]{TABS_BAR_ID});
            LOGGER.log(UjoLogger.WARN, msg, (Throwable)new IllegalUjormException(msg));
        }
    }

    protected final WebMarkupContainer getTabBar() {
        return (WebMarkupContainer)this.get(TABS_BAR_ID);
    }

    @Nonnull
    public IModel<String> getNextTitleModel(boolean next) {
        int i = this.getSelectedTab() + (next ? 1 : -1);
        return i >= 0 && i < this.getTabSize() ? ((UjoTab)((Object)this.getTabs().get(i))).getTitle() : new Model(null);
    }

    @Nullable
    public final String getNextTitle(boolean next) {
        return (String)this.getNextTitleModel(next).getObject();
    }
}

