/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.tabs;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.ujorm.core.IllegalUjormException;
import org.ujorm.tools.msg.MsgFormatter;
import org.ujorm.wicket.function.UjoSupplier;

public class UjoTab
extends AbstractTab {
    private final String cssClass;
    private final Class<? extends WebMarkupContainer> panel;
    private IModel<?> tabModel;
    private UjoSupplier<Boolean> visible;

    public UjoTab(@Nonnull IModel<String> title, @Nonnull Class<? extends WebMarkupContainer> panel) {
        this(title, null, panel);
    }

    public UjoTab(@Nonnull String title, String cssClass, @Nonnull Class<? extends WebMarkupContainer> panel) {
        this((IModel<String>)Model.of((Serializable)((Object)title)), cssClass, panel);
    }

    public UjoTab(@Nonnull String title, @Nullable String cssClass, @Nonnull Class<? extends WebMarkupContainer> panel, @Nullable UjoSupplier<Boolean> visible) {
        this((IModel<String>)Model.of((Serializable)((Object)title)), cssClass, panel, visible);
    }

    public UjoTab(@Nonnull IModel<String> title, @Nullable String cssClass, @Nonnull Class<? extends WebMarkupContainer> panel) {
        this(title, cssClass, panel, (UjoSupplier<Boolean>)null);
    }

    public UjoTab(@Nonnull IModel<String> title, @Nullable String cssClass, @Nonnull Class<? extends WebMarkupContainer> panel, @Nullable UjoSupplier<Boolean> visible) {
        super(title);
        this.cssClass = cssClass;
        this.panel = panel;
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible != null ? Boolean.TRUE.equals(this.visible.get()) : super.isVisible();
    }

    public IModel<?> getTabModel() {
        return this.tabModel;
    }

    public UjoTab setTabModel(IModel<?> tabModel) {
        this.tabModel = tabModel;
        return this;
    }

    public UjoTab setModel(IModel<?> tabModel) {
        this.setTabModel(tabModel);
        return this;
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public WebMarkupContainer getPanel(String panelId) throws IllegalStateException {
        try {
            return this.tabModel != null ? this.panel.getConstructor(String.class, IModel.class).newInstance(panelId, this.tabModel) : this.panel.getConstructor(String.class).newInstance(panelId);
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            String msg = MsgFormatter.format((String)"Can't create an instance of the class {} with {} constructor argument(s).", (Object[])new Serializable[]{this.panel.getName(), Integer.valueOf(this.tabModel != null ? 2 : 1)});
            throw new IllegalUjormException(msg, (Throwable)e);
        }
    }

    public Class<? extends WebMarkupContainer> getPanelClass() {
        return this.panel;
    }
}

