/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.grid;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.ujorm.Key;
import org.ujorm.criterion.Criterion;
import org.ujorm.orm.OrmUjo;
import org.ujorm.wicket.component.grid.OrmDataProvider;

public class OrmDataProviderCached<U extends OrmUjo>
extends OrmDataProvider<U> {
    @Nonnull
    private static final Duration dataLife = Duration.ofMinutes(2L);
    private LocalDateTime nextUpdate = LocalDateTime.now();
    private int lastFilterHash = 0;
    protected final int maxPages = 9;
    private int rowsPerPage = 10;
    private final List<U> rows = new ArrayList<U>(this.rowsPerPage);

    public OrmDataProviderCached(@Nonnull IModel<Criterion<U>> criterion) {
        super(criterion);
    }

    public OrmDataProviderCached(@Nonnull IModel<Criterion<U>> criterion, @Nonnull Key<? super U, ?> defaultSort) {
        super(criterion, defaultSort);
    }

    @Override
    public long size() {
        LocalDateTime now = LocalDateTime.now();
        Criterion crn = (Criterion)this.filter.getObject();
        int newHash = this.calculageHash(crn);
        if (now.isAfter(this.nextUpdate) || this.lastFilterHash != newHash) {
            this.nextUpdate = now.plus(this.getDataLife());
            this.lastFilterHash = newHash;
            this.refreshRows(crn);
        }
        return this.rows.size();
    }

    private int calculageHash(@Nullable Criterion<U> crn) {
        Key sortKey = super.getSortKey();
        int newHash = (crn != null ? crn.hashCode() : 0) * 51 + sortKey.hashCode();
        return newHash;
    }

    private void refreshRows(@Nonnull Criterion<U> crn) {
        this.rows.clear();
        Iterator<U> it = this.iterator(0L, this.getRowCountLimit(), crn);
        while (it.hasNext()) {
            this.rows.add(it.next());
        }
    }

    @Override
    @Nonnull
    public Iterator<U> iterator(long first, long count) {
        return this.rows.subList((int)first, (int)(first + count)).iterator();
    }

    @Override
    public <S> DataTable<U, S> createDataTable(int rowsPerPage) {
        DataTable<U, S> result = this.createDataTable("datatable", rowsPerPage);
        this.rowsPerPage = rowsPerPage;
        return result;
    }

    @Override
    public final <S> DataTable<U, S> createDataTable(String id, int rowsPerPage) {
        DataTable result = this.createDataTable(id, rowsPerPage, false);
        this.rowsPerPage = rowsPerPage;
        return result;
    }

    @Override
    public final <S> DataTable<U, S> createDataTable(int rowsPerPage, boolean insertToolbar) {
        DataTable result = this.createDataTable("datatable", rowsPerPage, insertToolbar);
        this.rowsPerPage = rowsPerPage;
        return result;
    }

    @Nonnull
    public Duration getDataLife() {
        return dataLife;
    }

    protected int getRowCountLimit() {
        return this.rowsPerPage * 9;
    }

    @Override
    public void clearCache() {
        this.nextUpdate = LocalDateTime.now();
    }

    public static <T extends OrmUjo> OrmDataProvider<T> of(@Nonnull IModel<Criterion<T>> criterion, Key<? super T, ?> defaultSort) {
        return new OrmDataProviderCached<T>(criterion, defaultSort);
    }

    public static <T extends OrmUjo> OrmDataProvider<T> of(@Nonnull IModel<Criterion<T>> criterion) {
        return new OrmDataProviderCached<T>(criterion, null);
    }

    public static <T extends OrmUjo> OrmDataProvider<T> of(@Nonnull Criterion<T> criterion, Key<? super T, ?> defaultSort) {
        return new OrmDataProviderCached<T>(new Model(criterion), defaultSort);
    }

    public static <T extends OrmUjo> OrmDataProvider<T> of(Criterion<T> criterion) {
        return new OrmDataProviderCached(new Model(criterion), null);
    }
}

