/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.form.fields;

import java.time.LocalDateTime;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.wicket.CssAppender;
import org.ujorm.wicket.component.form.fields.Field;
import org.ujorm.wicket.component.tools.DateTimes;

public class LocalDateTimeField<T>
extends Field<T> {
    public <U extends Ujo> LocalDateTimeField(Key<U, T> key) {
        super(key.getName(), key, null);
    }

    public <U extends Ujo> LocalDateTimeField(String componentId, Key<U, T> key, String cssClass) {
        super(componentId, key, cssClass);
    }

    @Override
    protected FormComponent createInput(String componentId, IModel<T> model) {
        TextField result = new TextField(componentId, LocalDateTime.class);
        result.add(new Behavior[]{new CssAppender(this.getInputCssClass())});
        result.setEnabled(this.isEnabled());
        result.setLabel(this.createLabelModel());
        result.setDefaultModel((IModel)Model.of());
        return result;
    }

    protected String getInputCssClass() {
        return "localDateTime";
    }

    protected String getDatePattern() {
        String key = "locale.datetime.pattern";
        return this.getLocalizer().getString("locale.datetime.pattern", (Component)this, DateTimes.getDefaultPattern("locale.datetime.pattern"));
    }
}

