/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket;

import java.io.Serializable;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.ILogData;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.ujorm.tools.Assert;

public class UjoEvent<U> {
    public static final UjoEvent EMPTY_EVENT = new UjoEvent("", new DummyTarget());
    private final String action;
    private final boolean showDialog;
    @Nullable
    private final U domain;
    private final AjaxRequestTarget target;

    public UjoEvent(@Nonnull String action, @Nonnull AjaxRequestTarget target) {
        this(action, null, target);
    }

    public UjoEvent(@Nonnull String action, @Nullable U ujo, @Nonnull AjaxRequestTarget target) {
        this(action, true, ujo, target);
    }

    public UjoEvent(@Nonnull String action, boolean dialogRequest, @Nullable U ujo, @Nonnull AjaxRequestTarget target) {
        this.action = (String)Assert.notNull((Object)action, (Object[])new String[]{"action"});
        this.domain = ujo;
        this.showDialog = dialogRequest;
        this.target = target;
    }

    @Nullable
    public U getDomain() {
        return this.domain;
    }

    @Nonnull
    public IModel<U> getUjoModel() {
        return new Model((Serializable)this.domain);
    }

    @Nonnull
    public AjaxRequestTarget getTarget() {
        return this.target;
    }

    public void addTarget(Component ... components) {
        this.target.add(components);
    }

    public String getAction() {
        return this.action;
    }

    public final boolean isAction(@Nonnull String action) {
        return action != null && this.action.hashCode() == action.hashCode() && this.action.equals(action);
    }

    public final boolean isAction(String ... actions) {
        for (String act : actions) {
            if (!this.isAction(act)) continue;
            return true;
        }
        return false;
    }

    public boolean showDialog() {
        return this.showDialog;
    }

    public String toString() {
        return "UjoEvent{ action=" + this.action + ", showDialog=" + this.showDialog + ", domain=" + this.domain + '}';
    }

    @Nonnull
    public static <T> UjoEvent<T> get(@Nonnull IEvent<?> argEvent) {
        Object payLoad = ((IEvent)Assert.notNull(argEvent, (Object[])new String[]{"argEvent"})).getPayload();
        return payLoad instanceof UjoEvent ? (UjoEvent)payLoad : EMPTY_EVENT;
    }

    private static final class DummyTarget
    implements AjaxRequestTarget {
        private DummyTarget() {
        }

        private UnsupportedOperationException newException() {
            return new UnsupportedOperationException(this.getClass().getSimpleName());
        }

        public void addListener(AjaxRequestTarget.IListener listener) {
            throw this.newException();
        }

        public void registerRespondListener(AjaxRequestTarget.ITargetRespondListener listener) {
            throw this.newException();
        }

        public String getLastFocusedElementId() {
            throw this.newException();
        }

        public Page getPage() {
            throw this.newException();
        }

        public void add(Component component, String markupId) {
            throw this.newException();
        }

        public void add(Component ... components) {
            throw this.newException();
        }

        public void addChildren(MarkupContainer parent, Class<?> childCriteria) {
            throw this.newException();
        }

        public void appendJavaScript(CharSequence javascript) {
            throw this.newException();
        }

        public void prependJavaScript(CharSequence javascript) {
            throw this.newException();
        }

        public void focusComponent(Component component) {
            throw this.newException();
        }

        public Collection<? extends Component> getComponents() {
            throw this.newException();
        }

        public IHeaderResponse getHeaderResponse() {
            throw this.newException();
        }

        public Integer getPageId() {
            throw this.newException();
        }

        public boolean isPageInstanceCreated() {
            throw this.newException();
        }

        public Integer getRenderCount() {
            throw this.newException();
        }

        public Class<? extends IRequestablePage> getPageClass() {
            throw this.newException();
        }

        public PageParameters getPageParameters() {
            throw this.newException();
        }

        public void respond(IRequestCycle irc) {
            throw this.newException();
        }

        public void detach(IRequestCycle irc) {
            throw this.newException();
        }

        public ILogData getLogData() {
            throw this.newException();
        }
    }
}

