/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.form;

import java.io.Serializable;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.validation.IValidator;
import org.ujorm.CompositeKey;
import org.ujorm.Key;
import org.ujorm.KeyList;
import org.ujorm.ListKey;
import org.ujorm.Ujo;
import org.ujorm.Validator;
import org.ujorm.core.IllegalUjormException;
import org.ujorm.core.UjoManager;
import org.ujorm.criterion.Criterion;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.OrmHandlerProvider;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.tools.Assert;
import org.ujorm.validator.ValidatorUtils;
import org.ujorm.wicket.OrmSessionProvider;
import org.ujorm.wicket.component.dialog.domestic.OfferModel;
import org.ujorm.wicket.component.form.UiValidator;
import org.ujorm.wicket.component.form.fields.BooleanField;
import org.ujorm.wicket.component.form.fields.ComboField;
import org.ujorm.wicket.component.form.fields.DateField;
import org.ujorm.wicket.component.form.fields.EnumField;
import org.ujorm.wicket.component.form.fields.Field;
import org.ujorm.wicket.component.form.fields.GridField;
import org.ujorm.wicket.component.form.fields.LocalDateField;
import org.ujorm.wicket.component.form.fields.OfferField;
import org.ujorm.wicket.component.form.fields.PasswordField;
import org.ujorm.wicket.component.form.fields.TextAreaField;
import org.ujorm.wicket.component.form.fields.TextField;

public class FieldProvider<U extends Ujo>
implements Serializable {
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(FieldProvider.class);
    public static final String PASSWORD_KEY_NAME = "password";
    private RepeatingView repeatingView;
    private Map<String, Field> fields;
    private U domain;
    private final boolean focusRequestEnabled = true;
    private transient OrmHandler ormHandler;
    private boolean disableRequest = false;
    @Nullable
    private transient Field<?> lastField;

    public FieldProvider(String repeatingViewId) {
        this(new RepeatingView(repeatingViewId));
    }

    public FieldProvider(RepeatingView repeatingView) {
        this(repeatingView, new LinkedHashMap<String, Field>(16));
    }

    public FieldProvider(RepeatingView repeatingView, Map<String, Field> fields) {
        this.repeatingView = repeatingView;
        this.fields = fields;
    }

    public <T> Field<T> add(Field<T> field) {
        Key<?, ?> key = field.getKey();
        Field<T> oldField = this.fields.put(key.getName(), field);
        if (oldField != null) {
            throw new IllegalUjormException("Field is assigned for the key: " + field);
        }
        this.repeatingView.add(new Component[]{field});
        this.lastField = field;
        this.addValidator(key, field);
        field.setOutputMarkupPlaceholderTag(true);
        if (this.disableRequest) {
            field.setEnabled(false);
        }
        return field;
    }

    protected String newChildId() {
        return this.repeatingView.newChildId();
    }

    public <T> Field<T> add(Key<? super U, T> key) {
        int length;
        Field field = key.isTypeOf(Boolean.class) ? new BooleanField<T>(this.newChildId(), key, null) : (key.isTypeOf(String.class) ? (this.isPasswordKey(key) ? new PasswordField<T>(this.newChildId(), key, null) : ((length = ValidatorUtils.getMaxLength((Validator)key.getValidator())) >= this.getTextAreaLimit() ? new TextAreaField<T>(this.newChildId(), key, null) : new TextField<T>(this.newChildId(), key, null))) : (key.isTypeOf(Enum.class) ? new EnumField<T>(this.newChildId(), key, "combo") : (key.isTypeOf(LocalDate.class) ? new LocalDateField<T>(this.newChildId(), key, null) : (key.isTypeOf(LocalDateTime.class) ? new Field<T>(this.newChildId(), key, null) : (key.isTypeOf(Date.class) ? new DateField<T>(this.newChildId(), key, null) : (key.isTypeOf(java.util.Date.class) ? new DateField<T>(this.newChildId(), key, null) : (key.isTypeOf(Ujo.class) ? new OfferField<T>(this.newChildId(), key) : (key instanceof ListKey && ((ListKey)key).isItemTypeOf(Ujo.class) ? new GridField<T>(this.newChildId(), key, null) : new Field<T>(this.newChildId(), key, null)))))))));
        return this.add(field);
    }

    public <T extends Ujo & Serializable> Field<T> add(Key<? super U, T> key, Criterion<T> filter) {
        return this.add(key, new OfferModel<T>(filter));
    }

    public <T extends Ujo & Serializable> Field<T> add(Key<? super U, T> key, OfferModel<T> model) {
        return this.add(new OfferField<T>(this.newChildId(), key, model));
    }

    public void add(Class<? super U> domainClass) {
        try {
            this.add(((Ujo)domainClass.newInstance()).readKeys());
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            throw new IllegalUjormException("Can't get keys of the domain " + domainClass, (Throwable)e);
        }
    }

    public void add(KeyList<? super U> fields) {
        for (Key key : fields) {
            this.add(key);
        }
    }

    public <T extends Ujo> Field<T> add(Key<? super U, T> key, Class<? extends Field> fieldClass) {
        try {
            return this.add(fieldClass.getConstructor(Key.class).newInstance(key));
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            throw new IllegalUjormException("Can't create instance of the " + fieldClass, (Throwable)e);
        }
    }

    public <T extends OrmUjo> Field<T> add(Key<? super U, T> key, Key<T, ?> display, Criterion<T> crn) {
        ComboField<T> result = ComboField.of(key, crn, display);
        return this.add(result);
    }

    public <T> T getValue(Key<? super U, T> key) {
        Field filed = this.fields.get(key.getName());
        return (T)(filed != null ? filed.getModelValue() : key.getDefault());
    }

    public <T> void setValue(Key<? super U, T> key, T value) {
        ((Field)((Object)this.getField(key))).setModelValue(value);
    }

    public <T> void setValue(Key<? super U, T> key, T value, AjaxRequestTarget target) {
        Object field = this.getField(key);
        ((Field)((Object)field)).setModelValue(value);
        target.add(new Component[]{field});
    }

    public Collection<Field> getFields() {
        return this.fields.values();
    }

    @Nonnull
    public <V, F extends Field<V>> F getField(Key<? super U, V> key) {
        Field result = this.fields.get(key.getName());
        return (F)((Object)((Field)((Object)Assert.notNull((Object)((Object)result), (Object[])new String[]{"Filed nebyl nalezen pro {}", key.getFullName()}))));
    }

    @Nonnull
    public <T> Field<T> getLast() throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        return (Field)((Object)Assert.notNull(this.lastField, (Object[])new Object[0]));
    }

    protected Set<String> getKeyNames() {
        return this.fields.keySet();
    }

    public RepeatingView getRepeatingView() {
        return this.repeatingView;
    }

    protected OrmHandler getOrmHandler() {
        Application appl;
        if (this.ormHandler != null && (appl = this.repeatingView.getPage().getApplication()) instanceof OrmHandlerProvider) {
            this.ormHandler = ((OrmHandlerProvider)appl).getOrmHandler();
        }
        return this.ormHandler;
    }

    protected boolean isMandatory(Key<? super U, ?> key) {
        MetaColumn column;
        OrmHandler handler = this.getOrmHandler();
        if (handler != null && (column = (MetaColumn)handler.findColumnModel(key, false)).isMandatory()) {
            return true;
        }
        return ValidatorUtils.isMandatoryValidator((Validator)key.getValidator());
    }

    protected void addValidator(Key<? super U, ?> key, Field field) {
        FormComponent input;
        Validator validator = key.getValidator();
        if (validator != null) {
            field.addValidator(new UiValidator(validator, key));
        } else if (this.isMandatory(key) && (input = field.getInput()) instanceof FormComponent) {
            input.setRequired(true);
        }
    }

    public void setDomain(U domain) {
        OrmSessionProvider session = new OrmSessionProvider();
        try {
            this.domain = this.copyToFields(this.cloneDomain(domain, session));
        }
        finally {
            session.closeSession();
        }
    }

    protected U cloneDomain(U domain, OrmSessionProvider session) throws NoSuchElementException, IllegalStateException {
        OrmUjo result = domain instanceof OrmUjo ? session.getSession().loadBy((OrmUjo)domain) : UjoManager.clone(domain, (int)this.getClonedDepth(), (Object)"clone");
        return (U)(result != null ? result : domain);
    }

    protected int getClonedDepth() {
        int result = 1;
        for (Field field : this.getFields()) {
            Key<?, ?> key = field.getKey();
            if (!(key instanceof CompositeKey)) continue;
            result = Math.max(result, ((CompositeKey)key).getKeyCount());
        }
        return result;
    }

    protected U copyToFields(U domain) {
        Assert.notNull(domain, (Object[])new String[]{"domain"});
        for (Field field : this.getFields()) {
            Key<?, ?> k = field.getKey();
            field.setModelValue(k.of(domain));
        }
        return domain;
    }

    public U getDomain() {
        this.copyToDomain(this.domain);
        return this.domain;
    }

    public void copyToDomain(U domain) {
        for (Field field : this.fields.values()) {
            if (!field.isEnabled()) continue;
            Key<?, ?> k = field.getKey();
            Object newValue = this.getValue(k);
            if (!k.isTypeOf(Ujo.class) && k.equals(domain, newValue)) continue;
            k.setValue(domain, newValue);
        }
    }

    public void copyValues(U domain, boolean toFields) {
        if (toFields) {
            this.copyToFields(domain);
        } else {
            this.copyToDomain(domain);
        }
    }

    public U getInputDomain() {
        return this.domain;
    }

    public int getTextAreaLimit() {
        return 180;
    }

    protected boolean isPasswordKey(Key<? super U, ?> key) {
        return key.getName().endsWith(PASSWORD_KEY_NAME) && (key.length() == PASSWORD_KEY_NAME.length() || key.charAt(key.length() - PASSWORD_KEY_NAME.length() - 1) == '.');
    }

    public void onChange(Key<? super U, ?> source) {
        this.onChange(source, "CHANGED");
    }

    public void onChange(Key<? super U, ?> source, String action) {
        ((Field)((Object)this.getField(source))).onChange(action);
    }

    public <T> void setEnabled(Key<? super U, T> key, boolean enabled) {
        Object field = this.getField(key);
        if (field != null) {
            field.setEnabled(enabled);
        }
    }

    public void setVisible(Key<? super U, ?> key, boolean visible) {
        Object field = this.getField(key);
        if (field != null) {
            field.setVisibilityAllowed(visible);
        }
    }

    public boolean isDisableRequest() {
        return this.disableRequest;
    }

    public void setDisablRequest(boolean disableRequest) {
        this.disableRequest = disableRequest;
    }

    public final FieldProvider<U> disableFields() {
        this.setDisablRequest(true);
        return this;
    }

    public <T> void addValidator(Key<? super U, T> key, Validator<? super T> validator) {
        Object field = this.getField(key);
        if (field != null) {
            ((Field)((Object)field)).addValidator(validator);
        }
    }

    public <T> void addValidatorUnchecked(Key<? super U, ? super T> key, Validator validator) {
        this.addValidator(key, validator);
    }

    public <T> void addValidator(Key<? super U, T> key, IValidator<? super T> validator) {
        Object field = this.getField(key);
        if (field != null) {
            ((Field)((Object)field)).addValidator(validator);
        }
    }

    public <T> void addCssStyle(Key<? super U, ? super T> key, String cssStyle) {
        Object field = this.getField(key);
        if (field != null) {
            ((Field)((Object)field)).addCssStyle(cssStyle);
        }
    }

    public void requestFocus(@Nonnull AjaxRequestTarget target) {
        Field<?> field = this.findFirstField();
        if (field != null) {
            try {
                field.requestFocus(target);
            }
            catch (OutOfMemoryError | RuntimeException e) {
                LOGGER.log(UjoLogger.WARN, "Focus", e);
            }
        }
    }

    @Nullable
    protected Field<?> findFirstField() {
        int max = this.repeatingView.size();
        for (int i = 0; i < max; ++i) {
            Field result;
            Component component = this.repeatingView.get(i);
            if (!(component instanceof Field) || !(result = (Field)component).isVisibilityAllowed() || !result.getInput().isEnabled() || result.getKey() == null) continue;
            return result;
        }
        return null;
    }
}

