/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.toolbar;

import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.attributes.ThrottlingSettings;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.form.AbstractChoice;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.util.time.Duration;
import org.ujorm.Ujo;
import org.ujorm.criterion.Criterion;
import org.ujorm.tools.Assert;
import org.ujorm.wicket.UjoEvent;
import org.ujorm.wicket.component.tools.ChoiceRendererNullable;

public abstract class AbstractToolbar<U extends Ujo>
extends GenericPanel<U> {
    protected static final Duration DEFAULT_DELAY = Duration.milliseconds((long)400L);
    @Nonnull
    private final IModel<Criterion<U>> criterionModel = Model.of();

    public AbstractToolbar(@Nonnull String id) {
        super(id);
    }

    public void onInitialize() {
        super.onInitialize();
        this.buildCriterion();
    }

    protected TextField createSearchField(String componentId) {
        return this.createSearchField(componentId, String.class, componentId);
    }

    protected TextField createSearchField(String componentId, Class<?> type) {
        return this.createSearchField(componentId, type, componentId);
    }

    protected final TextField createSearchField(String componentId, Class<?> type, String placeholderKey) {
        return this.createSearchField(componentId, type, (IModel<String>)new ResourceModel(placeholderKey, placeholderKey));
    }

    protected TextField createSearchField(String componentId, Class<?> type, IModel<String> placeholder) {
        TextField result = new TextField(componentId, (IModel)new Model(), type);
        result.add(new Behavior[]{new AttributeModifier("placeholder", placeholder)});
        result.setOutputMarkupId(true);
        this.addChangeBehavior((FormComponent)result);
        return result;
    }

    protected <E extends Enum<E>> DropDownChoice<E> createSearchChoice(@Nonnull String id, @Nonnull E defaultItem) {
        return this.createSearchChoice(id, (IModel<E>)Model.of(defaultItem));
    }

    protected <E extends Enum<E>> DropDownChoice<E> createSearchChoice(@Nonnull String id, @Nonnull E offerItem, boolean required) {
        return this.createSearchChoice(id, (IModel<E>)Model.of(offerItem), required);
    }

    protected <E extends Enum<E>> DropDownChoice<E> createSearchChoice(@Nonnull String id, @Nonnull IModel<E> defaultItemModel) {
        return this.createSearchChoice(id, defaultItemModel, false);
    }

    protected <E extends Enum<E>> DropDownChoice<E> createSearchChoice(@Nonnull String id, @Nonnull IModel<E> offerItem, boolean required) {
        Enum defaultValue = (Enum)Assert.notNull((Object)offerItem.getObject(), (Object[])new String[]{"defaultValue"});
        DropDownChoice result = new DropDownChoice(id, Arrays.asList(defaultValue.getDeclaringClass().getEnumConstants()), new ChoiceRendererNullable((Component)this));
        if (!required) {
            offerItem.setObject(null);
        }
        result.setRequired(required);
        result.setModel(offerItem);
        result.setOutputMarkupId(true);
        this.addChangeBehavior((AbstractChoice)result);
        return result;
    }

    public IModel<Criterion<U>> getCriterion() {
        return this.criterionModel;
    }

    protected abstract void buildCriterion();

    protected void addChangeBehavior(@Nonnull FormComponent field) {
        AjaxFormComponentUpdatingBehavior behavior = this.createAjaxUpdateingBehaviorWithDelay();
        field.add(new Behavior[]{behavior});
    }

    protected void addChangeBehavior(@Nonnull AbstractChoice field) {
        field.add(new Behavior[]{this.createAjaxUpdateingBehavior("onchange")});
        field.add(new Behavior[]{this.createAjaxUpdateingBehavior("onkeyup")});
    }

    protected AjaxFormComponentUpdatingBehavior createAjaxUpdateingBehaviorWithDelay() {
        return new AjaxFormComponentUpdatingBehavior("keyup"){

            protected void onUpdate(AjaxRequestTarget target) {
                AbstractToolbar.this.buildCriterion();
                AbstractToolbar.this.onUpdate(target);
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.setThrottlingSettings(new ThrottlingSettings("thrId", DEFAULT_DELAY, true));
            }
        };
    }

    protected AjaxEventBehavior createAjaxUpdateingBehavior(String jsEvent) {
        return new AjaxFormComponentUpdatingBehavior(jsEvent){

            protected void onUpdate(AjaxRequestTarget target) {
                AbstractToolbar.this.buildCriterion();
                AbstractToolbar.this.onUpdate(target);
            }
        };
    }

    protected void onUpdate(AjaxRequestTarget target) {
        this.send((IEventSink)this.getPage(), Broadcast.BREADTH, new UjoEvent(this.getDefaultActionName(), target));
    }

    protected String getDefaultActionName() {
        return "FILTER";
    }

    public void requestFocus(@Nonnull AjaxRequestTarget target) {
    }
}

