/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.grid;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.export.IExportableColumn;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.ujorm.Ujo;
import org.ujorm.core.KeyRing;
import org.ujorm.wicket.component.grid.KeyColumn;

public class KeyColumnExportable<U extends Ujo, T>
implements IExportableColumn<U, KeyRing<U>> {
    private static final long serialVersionUID = 1L;
    private final KeyColumn<U, T> column;

    public KeyColumnExportable(KeyColumn<U, T> column) {
        this.column = column;
    }

    public IModel<T> getDataModel(IModel<U> rowModel) {
        return new Model((Serializable)this.getDataValue(rowModel));
    }

    protected T getDataValue(IModel<U> rowModel) {
        Ujo row = (Ujo)rowModel.getObject();
        Object result = this.column.getKey().of(row);
        return (T)result;
    }

    public IModel<String> getDisplayModel() {
        return this.column.getDisplayModel();
    }

    public Component getHeader(String componentId) {
        return this.column.getHeader(componentId);
    }

    public KeyRing<U> getSortProperty() {
        return (KeyRing)this.column.getSortProperty();
    }

    public boolean isSortable() {
        return this.column.isSortable();
    }

    public void populateItem(Item<ICellPopulator<U>> cellItem, String componentId, IModel<U> rowModel) {
        this.column.populateItem(cellItem, componentId, rowModel);
    }

    public void detach() {
        this.column.detach();
    }

    public String toString() {
        return this.column.toString();
    }
}

