/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.grid;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.jetbrains.annotations.Nullable;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.core.KeyRing;
import org.ujorm.wicket.component.grid.KeyColumn;

public class KeyColumnDecimal<U extends Ujo>
extends KeyColumn<U, BigDecimal> {
    private static final long serialVersionUID = 1L;
    public static String DEFAULT_CSS_CLASS = "decimal";
    public static final String DEFAULT_DECIMAL_FORMAT_KEY = "locale.decimal.pattern";
    private String localeDecimalFormatKey;

    public KeyColumnDecimal(KeyRing<U> key, KeyRing<U> keySortable) {
        this(key, keySortable, DEFAULT_DECIMAL_FORMAT_KEY);
    }

    public KeyColumnDecimal(KeyRing<U> key, KeyRing<U> keySortable, String localeDecimalFormatKey) {
        super(key, keySortable);
        this.localeDecimalFormatKey = localeDecimalFormatKey;
        this.setCssClass(DEFAULT_CSS_CLASS);
    }

    @Override
    @Nullable
    protected Component createValueCoponent(String componentId, final IModel<?> valueModel, U ujo) {
        final Label result = new Label(componentId);
        result.setDefaultModel((IModel)new Model(){

            public Serializable getObject() {
                BigDecimal modelObject = (BigDecimal)valueModel.getObject();
                if (modelObject != null) {
                    DecimalFormat decimalFormat = new DecimalFormat(KeyColumnDecimal.this.getDatePattern((Component)result));
                    return decimalFormat.format(modelObject);
                }
                return null;
            }
        });
        return result;
    }

    protected String getDatePattern(Component component) {
        return component.getLocalizer().getString(this.localeDecimalFormatKey, component, "#,##0.00");
    }

    public static <U extends Ujo, T> KeyColumn<U, T> of(Key<U, T> key, boolean sorted, String cssClass) {
        return KeyColumnDecimal.of(key, sorted, cssClass, DEFAULT_DECIMAL_FORMAT_KEY);
    }

    public static <U extends Ujo, T> KeyColumn<U, T> of(Key<U, T> key, boolean sorted, String cssClass, String localeDateFormatKey) {
        KeyRing serializableKey = KeyRing.of(key);
        KeyColumnDecimal<U> result = new KeyColumnDecimal<U>(serializableKey, sorted ? serializableKey : null, localeDateFormatKey);
        result.setCssClass(cssClass);
        return result;
    }
}

