/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.dialog.domestic;

import java.awt.Dimension;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Args;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.Key;
import org.ujorm.KeyList;
import org.ujorm.Ujo;
import org.ujorm.core.KeyRing;
import org.ujorm.core.UjoManager;
import org.ujorm.criterion.Criterion;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaIndex;
import org.ujorm.orm.metaModel.MetaTable;
import org.ujorm.tools.Assert;
import org.ujorm.wicket.OrmSessionProvider;
import org.ujorm.wicket.component.dialog.domestic.SelectUjo;
import org.ujorm.wicket.component.form.Closeable;
import org.ujorm.wicket.component.grid.AbstractDataProvider;
import org.ujorm.wicket.component.grid.CommonAction;
import org.ujorm.wicket.component.grid.CommonActionPanel;
import org.ujorm.wicket.component.grid.KeyColumn;
import org.ujorm.wicket.component.grid.ListDataProvider;
import org.ujorm.wicket.component.grid.OrmDataProvider;

public class OfferModel<U extends Ujo & Serializable>
implements Serializable {
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(OfferModel.class);
    private static final boolean ENABLE_TOOLBAR = true;
    private final Criterion<U> filter;
    private final IModel<Criterion<U>> filterModel;
    private IModel<Criterion<U>> highliting;
    private IModel<String> title;
    private final Dimension dimension = new Dimension(700, 400);
    private KeyList<U> columns;
    private KeyList<U> finders;
    private KeyList<?> id;
    private KeyList<?> display;
    private AbstractDataProvider provider;
    private int rowCount = 10;
    private transient OrmHandler ormHandler;
    private Closeable<U> closable;
    private boolean enableToolbar = true;

    public OfferModel(Class<U> type) {
        this(UjoManager.getInstance().readKeys((Class)Args.notNull(type, (String)"type")).getFirstKey().forAll());
    }

    public OfferModel(@NotNull Criterion<U> filter) {
        this.filter = (Criterion)Assert.notNull(filter, (Object[])new String[]{"filter"});
        this.filterModel = Model.of(filter);
        this.highliting = new Model(null);
    }

    @NotNull
    public Criterion<U> getFilter() {
        return this.filter;
    }

    @NotNull
    public IModel<Criterion<U>> getFilterModel() {
        return this.filterModel;
    }

    @Nullable
    public void setHighliting(@Nullable Criterion<U> highliting) {
        this.highliting.setObject(highliting);
    }

    @NotNull
    public IModel<Criterion<U>> getHighliting() {
        return this.highliting;
    }

    @NotNull
    public Class<U> getType() {
        return this.filter.getDomain();
    }

    @NotNull
    public IModel<String> getTitle() {
        if (this.title == null) {
            this.title = new Model((Serializable)((Object)"Offer"));
        }
        return this.title;
    }

    public void setDimension(int width, int height) {
        this.dimension.width = width;
        this.dimension.height = height;
    }

    @NotNull
    public Dimension getDimension() {
        return this.dimension;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public <V> KeyList<U> getColumns() {
        if (this.columns == null) {
            ArrayList<Key> keys = new ArrayList<Key>(32);
            KeyList fullKeys = UjoManager.getInstance().readKeys(this.getType());
            Key<U, V> id = this.getId();
            for (Key key : fullKeys) {
                if (id == key || key.isTypeOf(Ujo.class)) continue;
                keys.add(key);
            }
            this.columns = keys.isEmpty() ? fullKeys : KeyRing.of(keys);
        }
        return this.columns;
    }

    public void setColumns(KeyList<U> columns) {
        this.columns = columns;
    }

    public void setFinders(KeyList<U> finders) {
        this.finders = finders;
    }

    public <V> KeyList<U> getFinders() {
        if (this.finders == null) {
            Key key;
            Iterator iterator;
            if (!this.isEnableToolbar()) {
                this.finders = KeyRing.of((Key)this.getColumns().getFirstKey());
                return this.finders;
            }
            ArrayList<Key> keys = new ArrayList<Key>(4);
            if (this.isOrm()) {
                this.getFinders4Orm(keys);
            }
            if (keys.isEmpty()) {
                iterator = this.getColumns().iterator();
                while (iterator.hasNext()) {
                    key = (Key)iterator.next();
                    if (!key.isTypeOf(String.class)) continue;
                    keys.add(key);
                    break;
                }
            }
            if (keys.isEmpty() && (iterator = this.getColumns().iterator()).hasNext()) {
                key = (Key)iterator.next();
                keys.add(key);
            }
            this.finders = keys.isEmpty() ? this.columns : KeyRing.of(keys);
        }
        return this.finders;
    }

    protected void getFinders4Orm(List<Key> result) throws IllegalStateException {
        for (MetaIndex index : this.getMetaTable().getIndexCollection()) {
            result.add(((MetaColumn)index.getColumns().get(0)).getKey());
        }
        if (result.size() > 1) {
            Collections.sort(result, new Comparator<Key>(){

                @Override
                public int compare(Key k1, Key k2) {
                    Boolean b1 = !k1.isTypeOf(String.class);
                    Boolean b2 = !k2.isTypeOf(String.class);
                    return b1.compareTo(b2);
                }
            });
            for (int i = result.size() - 1; i > 0; --i) {
                Key key = result.get(i);
                if (!key.isTypeOf(String.class)) continue;
                result.remove(i);
            }
        }
    }

    public AbstractDataProvider getProvider() {
        if (this.provider == null) {
            Key sortKey = this.getColumns().getFirstKey();
            this.provider = this.isOrm() ? new OrmDataProvider<U>(this.getFilterModel(), sortKey) : new ListDataProvider<U>(this.getFilterModel(), sortKey);
            this.addTableColumns(this.provider);
            this.provider.setHighlighting(this.highliting);
        }
        return this.provider;
    }

    protected void addTableColumns(AbstractDataProvider provider) {
        provider.add(this.createSelectColumn("SELECT"));
        KeyList<U> columns = this.getColumns();
        int max = columns.size();
        for (int i = 0; i < max; ++i) {
            Key key = columns.get(i);
            if (i == 0) {
                provider.add(key);
                continue;
            }
            provider.add(key);
        }
    }

    public KeyColumn<U, Object> createSelectColumn(final String action) {
        Key<SelectUjo, Boolean> column = SelectUjo.SELECT;
        KeyColumn result = new KeyColumn<U, Object>(KeyRing.of(column), null){

            @Override
            public void populateItem(Item<ICellPopulator<U>> item, String componentId, IModel<U> model) {
                item.add(new Component[]{new CommonActionPanel(componentId, (Ujo)model.getObject(), CommonAction.of(action)){

                    protected void onClick(AjaxRequestTarget target, CommonAction action) {
                        if (OfferModel.this.closable != null) {
                            OfferModel.this.closable.closeDialog(target, this.row);
                        } else {
                            LOGGER.log(UjoLogger.WARN, "Can't close dialog");
                        }
                    }
                }});
            }
        };
        result.setCssClass("actionColumn");
        return result;
    }

    protected boolean isOrm() {
        return OrmUjo.class.isAssignableFrom(this.getType());
    }

    public <S> DataTable<U, S> createDataTable() {
        return this.getProvider().createDataTable(this.getRowCount());
    }

    public void setProvider(AbstractDataProvider provider) {
        this.provider = provider;
    }

    @Nullable
    public <D extends Ujo> Key<D, U> getDisplay() {
        return this.display != null ? this.display.getFirstKey() : null;
    }

    public <D extends Ujo> void setDisplay(@Nullable Key<? super D, U> display) {
        this.display = display != null ? KeyRing.of(display) : null;
    }

    @NotNull
    public <V> Key<U, V> getId() {
        if (this.id == null) {
            if (this.isOrm()) {
                MetaTable table = this.getMetaTable();
                this.id = KeyRing.of((Key)table.getFirstPK().getKey());
            } else {
                KeyList fullKeys = UjoManager.getInstance().readKeys(this.getType());
                this.id = this.findKeyByName("ID", fullKeys);
                if (this.id == null) {
                    this.id = KeyRing.of((Key)fullKeys.getFirstKey());
                }
            }
        }
        return this.id.getFirstKey();
    }

    protected MetaTable getMetaTable() throws IllegalStateException {
        Class<U> ormType = this.getType();
        return this.getOrmHandler().findTableModel(ormType);
    }

    @Nullable
    protected KeyList<?> findKeyByName(String keyName, KeyList<U> fullKeys) {
        for (Key key : fullKeys) {
            if (!keyName.equals(key.getName().toUpperCase(Locale.ENGLISH))) continue;
            return KeyRing.of((Key)key);
        }
        return null;
    }

    public <D extends Ujo> void setId(@Nullable Key<? super D, U> id) {
        this.id = id != null ? KeyRing.of(id) : null;
    }

    protected OrmHandler getOrmHandler() {
        if (this.ormHandler == null) {
            this.ormHandler = OrmSessionProvider.getOrmHandler();
        }
        return this.ormHandler;
    }

    public Closeable<U> getClosable() {
        return this.closable;
    }

    public void setClosable(@NotNull Closeable<U> closable) {
        this.closable = (Closeable)Assert.notNull(closable, (Object[])new String[]{"closable"});
    }

    public boolean isEnableToolbar() {
        return this.enableToolbar;
    }

    public void setEnableToolbar(boolean enableToolbar) {
        this.enableToolbar = enableToolbar;
    }
}

