/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.dialog.domestic;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.Ujo;
import org.ujorm.criterion.Criterion;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.wicket.CssAppender;
import org.ujorm.wicket.UjoEvent;
import org.ujorm.wicket.component.dialog.domestic.AbstractDialogPane;
import org.ujorm.wicket.component.dialog.domestic.OfferModel;
import org.ujorm.wicket.component.dialog.domestic.OfferToolbar;
import org.ujorm.wicket.component.grid.AbstractDataProvider;

public class OfferDialogPane<T extends Ujo & Serializable>
extends AbstractDialogPane<T> {
    private static final long serialVersionUID = 20150212L;
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(OfferDialogPane.class);
    private OfferToolbar<T> toolbar;
    protected final OfferModel<T> model;

    public OfferDialogPane(ModalWindow modalWindow, OfferModel<T> model) {
        super(modalWindow, new Model(), false);
        this.repeater.setVisibilityAllowed(false);
        this.model = model;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        Component[] componentArray = new Component[1];
        this.toolbar = new OfferToolbar<T>("toolbar", this.model.getFinders());
        componentArray[0] = this.toolbar;
        this.form.add(componentArray);
        this.toolbar.setVisibilityAllowed(this.model.isEnableToolbar());
        this.form.add(new Component[]{this.model.createDataTable()});
    }

    public AbstractDataProvider<T> getColumns() {
        return this.model.getProvider();
    }

    @Override
    @Deprecated
    protected void setFeedback(IModel<String> message) {
        if (message != null) {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    @Override
    protected AjaxButton createActionButton(String id, String propertyName) {
        AjaxButton result = new AjaxButton(id, this.getButtonModel(propertyName), this.form){

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                try {
                    Object row = OfferDialogPane.this.getBaseModelObject();
                    if (row != null) {
                        OfferDialogPane.this.model.getClosable().closeDialog(target, row);
                    }
                }
                catch (OutOfMemoryError | RuntimeException e) {
                    LOGGER.log(UjoLogger.WARN, "Wrong selection", e);
                }
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                target.add(new Component[]{form});
            }
        };
        result.add(new Behavior[]{new CssAppender("btn btn-primary btn-offer")});
        return result;
    }

    @Override
    @Nullable
    public T getBaseModelObject() {
        try {
            DataTable dataTable = (DataTable)this.form.get("datatable");
            long firstRowIndex = dataTable.getCurrentPage() * dataTable.getItemsPerPage();
            Iterator iterator = dataTable.getDataProvider().iterator(firstRowIndex, 1L);
            if (iterator.hasNext()) {
                return (T)((Ujo)iterator.next());
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.log(UjoLogger.ERROR, "GetBaseModeObject failed", (Throwable)e);
            return null;
        }
    }

    public void onEvent(IEvent<?> argEvent) {
        UjoEvent event = UjoEvent.get(argEvent);
        if (event != null && event.isAction("FILTER")) {
            this.buildCriterion();
            this.reloadTable(event.getTarget());
            argEvent.stop();
        }
    }

    protected void buildCriterion() {
        Criterion crn1 = this.model.getFilter();
        Criterion crn2 = (Criterion)this.toolbar.getCriterion().getObject();
        Criterion crn3 = crn2 != null ? crn1.and(crn2) : crn1;
        this.model.getFilterModel().setObject((Object)crn3);
    }

    public void reloadTable(@NotNull AjaxRequestTarget target) {
        target.add(new Component[]{this.getTable()});
    }

    protected <S> DataTable<T, S> getTable() {
        return (DataTable)this.form.get("datatable");
    }

    @Override
    public void show(@NotNull AjaxRequestTarget target, IModel<String> title, IModel<T> body) {
        this.toolbar.requestFocus(target);
        this.buildCriterion();
        this.reloadTable(target);
        super.show(target, title, body, null);
    }
}

