/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.grid;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackHeadersToolbar;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxNavigationToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.NoRecordsToolbar;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.OddEvenItem;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.Key;
import org.ujorm.KeyList;
import org.ujorm.Ujo;
import org.ujorm.core.IllegalUjormException;
import org.ujorm.core.KeyRing;
import org.ujorm.criterion.Criterion;
import org.ujorm.extensions.ValueWrapper;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;
import org.ujorm.tools.msg.MsgFormatter;
import org.ujorm.wicket.CssAppender;
import org.ujorm.wicket.component.grid.CommonAction;
import org.ujorm.wicket.component.grid.CommonActionPanel;
import org.ujorm.wicket.component.grid.KeyColumn;
import org.ujorm.wicket.component.grid.KeyColumnBoolean;
import org.ujorm.wicket.component.grid.KeyColumnDate;
import org.ujorm.wicket.component.grid.KeyColumnDecimal;
import org.ujorm.wicket.component.grid.KeyColumnEnum;
import org.ujorm.wicket.component.grid.KeyColumnExportable;
import org.ujorm.wicket.component.grid.KeyColumnLocalDate;
import org.ujorm.wicket.component.grid.KeyColumnLocalDateTime;
import org.ujorm.wicket.component.grid.UjoDataTable;
import org.ujorm.wicket.component.toolbar.InsertToolbar;

public abstract class AbstractDataProvider<U extends Ujo>
extends SortableDataProvider<U, Object> {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_DATATABLE_ID = "datatable";
    protected static final String DEFAULT_CSS_SELECTED = "selected";
    public static final String DEFAULT_CSS_ACTION = "actionColumn";
    protected Long size;
    @NotNull
    protected final IModel<Criterion<U>> filter;
    protected IModel<Criterion<U>> highlighting;
    @NotNull
    private final List<IColumn<U, ?>> columns = new ArrayList();
    private boolean defaultColumnSorting = true;

    public AbstractDataProvider(@NotNull IModel<Criterion<U>> criterion) {
        this(criterion, null);
    }

    public AbstractDataProvider(@NotNull IModel<Criterion<U>> filter, @Nullable Key<? super U, ?> defaultSort) {
        this.filter = (IModel)Assert.notNull(filter, (Object[])new String[]{"Filter is required"});
        if (defaultSort == null) {
            KeyRing keys = KeyRing.of((Class)((Criterion)filter.getObject()).getDomain());
            defaultSort = keys.getFirstKey();
        }
        this.setSort(defaultSort);
    }

    public final void setSort(Key<? super U, ?> key) {
        super.setSort((Object)KeyRing.of(key), key.isAscending() ? SortOrder.ASCENDING : SortOrder.DESCENDING);
    }

    @Nullable
    public Key<U, ?> getSortKey() {
        SortParam sort = this.getSort();
        if (sort != null) {
            Object key = this.getSort().getProperty();
            return key instanceof KeyRing ? ((KeyRing)key).getFirstKey().descending(!sort.isAscending()) : null;
        }
        return null;
    }

    public Key<U, ?>[] getSortKeys() {
        Key[] keyArray;
        Key<U, ?> columnKey = this.getSortKey();
        if (columnKey != null) {
            Key[] keyArray2 = new Key[1];
            keyArray = keyArray2;
            keyArray2[0] = columnKey;
        } else {
            keyArray = new Key[]{};
        }
        return keyArray;
    }

    public abstract Iterator<U> iterator(long var1, long var3);

    public abstract long size();

    public abstract void detach();

    public Class<U> getDomainClass() {
        return ((Criterion)this.filter.getObject()).getDomain();
    }

    public IModel<U> model(U object) {
        return new Model((Serializable)object);
    }

    public boolean add(IColumn<? super U, ?> column) {
        return this.columns.add(column);
    }

    public void add(KeyList<? super U> columns) {
        for (Key t : columns) {
            this.add(t);
        }
    }

    public <V> boolean add(Key<? super U, V> column, CssAppender cssClass) {
        boolean result = this.add(column);
        ((KeyColumn)this.columns.get(this.columns.size() - 1)).setCssClass(cssClass.getCssClass());
        return result;
    }

    public <V> boolean add(Key<? super U, V> column) {
        return this.add((IColumn<? super U, ?>)this.createKeyColumn(column));
    }

    public <V> KeyColumn<? super U, V> createKeyColumn(Key<? super U, V> column) {
        Class colType;
        Class clazz = colType = column.isTypeOf(ValueWrapper.class) ? ValueWrapper.getInstance((Class)column.getType()).readPersistentClass() : column.getType();
        if (Boolean.class.isAssignableFrom(colType)) {
            return KeyColumnBoolean.of(column, this.isSortingEnabled(column));
        }
        if (BigDecimal.class.isAssignableFrom(colType)) {
            return KeyColumnDecimal.of(column, this.isSortingEnabled(column), "number");
        }
        if (Number.class.isAssignableFrom(colType)) {
            return KeyColumn.of(column, this.isSortingEnabled(column), "number");
        }
        if (Date.class.isAssignableFrom(colType)) {
            return KeyColumnDate.of(column, this.isSortingEnabled(column), KeyColumnDate.DEFAULT_CSS_CLASS);
        }
        if (java.util.Date.class.isAssignableFrom(colType)) {
            return KeyColumnDate.of(column, this.isSortingEnabled(column), "datetime", "locale.datetime.pattern");
        }
        if (LocalDateTime.class.isAssignableFrom(colType)) {
            return KeyColumnLocalDateTime.of(column, this.isSortingEnabled(column), "datetime", "locale.datetime.pattern");
        }
        if (LocalDate.class.isAssignableFrom(colType)) {
            return KeyColumnLocalDate.of(column, this.isSortingEnabled(column), "datetime", "locale.date.pattern");
        }
        if (Enum.class.isAssignableFrom(colType)) {
            return KeyColumnEnum.of(column, this.isSortingEnabled(column), "enum");
        }
        return KeyColumn.of(column, this.isSortingEnabled(column), null);
    }

    public <V> void add(Key<? super U, V> column, Class<? extends WebMarkupContainer> panelClass) {
        this.add(column, panelClass, false, null);
    }

    public <V> void add(@NotNull Key<? super U, V> column, @NotNull Class<? extends WebMarkupContainer> panelClass, boolean sortable, @Nullable String cssClass) {
        this.add(column, panelClass, (Key<? super U, V>)(sortable ? column : null), cssClass);
    }

    public <V> void add(@NotNull Key<? super U, V> column, final @NotNull Class<? extends WebMarkupContainer> panelClass, @Nullable Key<? super U, V> sortColumn, @Nullable String cssClass) {
        final Class domainType = column.getDomainType();
        final KeyRing keyCol = KeyRing.of(column);
        KeyRing sortCol = sortColumn == null ? null : (column.equals(sortColumn) ? keyCol : KeyRing.of(sortColumn));
        KeyColumn keyColumn = new KeyColumn<U, Object>(keyCol, sortCol){

            @Override
            public void populateItem(Item<ICellPopulator<U>> item, String componentId, IModel<U> model) {
                try {
                    Constructor constr = panelClass.getConstructor(String.class, domainType);
                    item.add(new Component[]{(Component)constr.newInstance(componentId, model.getObject())});
                }
                catch (OutOfMemoryError | ReflectiveOperationException | RuntimeException e) {
                    String msg = MsgFormatter.format((CharSequence)"The {} must have got two constructor arguments type of '{}' and '{}'.", (Object[])new Serializable[]{panelClass, String.class.getName(), domainType.getName()});
                    throw new IllegalUjormException(msg, e);
                }
            }

            @Override
            public String getCssClass() {
                return Check.hasLength((CharSequence)this.cssClass) ? this.cssClass : AbstractDataProvider.this.createKeyColumn(keyCol.getFirstKey()).getCssClass();
            }
        };
        if (Check.hasLength((CharSequence)cssClass)) {
            keyColumn.setCssClass(cssClass);
        }
        this.add((IColumn<? super U, ?>)keyColumn);
    }

    public <V> void add(@NotNull Key<? super U, V> column, final CommonAction ... actions) {
        KeyColumn col = new KeyColumn<U, Object>(KeyRing.of(column), null){

            @Override
            public void populateItem(Item<ICellPopulator<U>> item, String componentId, IModel<U> model) {
                item.add(new Component[]{new CommonActionPanel<Ujo>(componentId, (Ujo)model.getObject(), actions)});
            }
        };
        col.setCssClass(DEFAULT_CSS_ACTION);
        this.add((IColumn<? super U, ?>)col);
    }

    protected String getCssSelected() {
        return DEFAULT_CSS_SELECTED;
    }

    protected boolean isSortingEnabled(Key<U, ?> column) throws IllegalArgumentException {
        return this.defaultColumnSorting;
    }

    public <S> DataTable<U, S> createDataTable(int rowsPerPage) {
        return this.createDataTable(DEFAULT_DATATABLE_ID, rowsPerPage);
    }

    public <S> DataTable<U, S> createDataTable(String id, int rowsPerPage) {
        return this.createDataTable(id, rowsPerPage, false);
    }

    public <S> DataTable<U, S> createDataTable(int rowsPerPage, boolean insertToolbar) {
        return this.createDataTable(DEFAULT_DATATABLE_ID, rowsPerPage, insertToolbar);
    }

    public <S> DataTable<U, S> createDataTable(String id, int rowsPerPage, boolean insertToolbar) {
        UjoDataTable result = new UjoDataTable<U, S>(id, this.getColumns(), (IDataProvider)this, rowsPerPage){

            protected Item<U> newRowItem(String id, int index, IModel<U> model) {
                Criterion crn;
                OddEvenItem result = new OddEvenItem(id, index, model);
                if (AbstractDataProvider.this.highlighting != null && (crn = (Criterion)AbstractDataProvider.this.highlighting.getObject()) != null && crn.evaluate((Ujo)model.getObject())) {
                    result.add(new Behavior[]{new CssAppender(AbstractDataProvider.this.getCssSelected())});
                }
                return result;
            }
        };
        result.setOutputMarkupId(true);
        result.setVersioned(false);
        this.createTopToolbars(result);
        this.createBottomToolbars(result);
        if (insertToolbar) {
            result.addBottomToolbar(new InsertToolbar<U>(result, this.getDomainClass()));
        }
        return result;
    }

    protected <S> void createTopToolbars(DataTable<U, S> result) {
        result.addTopToolbar((AbstractToolbar)new AjaxNavigationToolbar(result));
        result.addTopToolbar((AbstractToolbar)new AjaxFallbackHeadersToolbar(result, (ISortStateLocator)this));
    }

    protected <S> void createBottomToolbars(DataTable<U, S> result) {
        result.addBottomToolbar((AbstractToolbar)new NoRecordsToolbar(result));
    }

    public final boolean isDefaultColumnSorting() {
        return this.defaultColumnSorting;
    }

    public void setDefaultColumnSorting(boolean defaultColumnSorting) {
        this.defaultColumnSorting = defaultColumnSorting;
    }

    public <T> List<IColumn<U, T>> getColumns() {
        return this.columns;
    }

    protected <S> List<KeyColumnExportable<U, S>> getExportableColumns(boolean exportable) {
        ArrayList<KeyColumnExportable<U, S>> result = new ArrayList<KeyColumnExportable<U, S>>(this.getColumns().size());
        for (IColumn column : this.getColumns()) {
            if (!(column instanceof KeyColumn)) continue;
            result.add(new KeyColumnExportable((KeyColumn)column));
        }
        return result;
    }

    public void setCssClass(Key<? super U, ?> key, String cssClass) {
        for (IColumn<U, ?> iColumn : this.columns) {
            if (!(iColumn instanceof KeyColumn) || !((KeyColumn)iColumn).getKey().equals(key)) continue;
            ((KeyColumn)iColumn).setCssClass(cssClass);
            break;
        }
    }

    @Nullable
    public IModel<Criterion<U>> getHighlighting() {
        return this.highlighting;
    }

    public void setHighlighting(@Nullable IModel<Criterion<U>> criterionModel) {
        this.highlighting = criterionModel;
    }

    public void setHighlighting(@NotNull Criterion<U> criterion) {
        this.setHighlighting((IModel<Criterion<U>>)new Model(criterion));
    }

    @Deprecated
    public final void setSelected(@Nullable IModel<Criterion<U>> criterionModel) {
        this.setHighlighting(criterionModel);
    }

    @Deprecated
    public final void setSelected(@NotNull Criterion<U> criterion) {
        this.setHighlighting(criterion);
    }

    protected U getFirstTableRow(@NotNull DataTable dataTable) {
        Long firstRowIndex = dataTable.getCurrentPage() * dataTable.getItemsPerPage();
        Iterator iterator = dataTable.getDataProvider().iterator(firstRowIndex.longValue(), 1L);
        return (U)(iterator.hasNext() ? (Ujo)iterator.next() : null);
    }

    public boolean insertRow(U row) {
        throw new UnsupportedOperationException();
    }

    public long deleteRow(Criterion<? super U> deleteCondition) {
        throw new UnsupportedOperationException();
    }

    public long updateRow(Criterion<? super U> updateCondition, U updatedRow) {
        throw new UnsupportedOperationException();
    }
}

