/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.form;

import java.io.Serializable;
import org.apache.wicket.validation.INullAcceptingValidator;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.Validator;
import org.ujorm.core.KeyRing;
import org.ujorm.tools.Assert;

public class UiValidator<T>
implements IValidator<T>,
INullAcceptingValidator<T>,
Serializable {
    public static final String PROPERTY_PREFIX = "validator.";
    private final Validator<T> validator;
    private final KeyRing<Ujo> key;

    public UiValidator(Validator<T> validator, Key<Ujo, T> key) {
        this(validator, KeyRing.of(key));
    }

    public UiValidator(@NotNull Validator<T> validator, @Nullable KeyRing key) {
        this.validator = (Validator)Assert.notNull(validator, (Object[])new String[]{"validator"});
        this.key = key;
    }

    public void validate(IValidatable<T> validatable) {
        org.ujorm.validator.ValidationError error = this.validator.validate(validatable.getValue(), this.key != null ? this.key.getFirstKey() : null, null);
        if (error != null) {
            ValidationError wicketErr = new ValidationError();
            wicketErr.setMessage(error.getDefaultMessage() + " [" + error.getLocalizationKey() + "]");
            wicketErr.addKey(error.getLocalizationKey() + "." + this.key.getFirstKey().getName());
            wicketErr.addKey(error.getLocalizationKey());
            wicketErr.setVariables(error.getArguments());
            validatable.error((IValidationError)wicketErr);
        }
    }

    public Validator getValidator() {
        return this.validator;
    }

    public String toString() {
        return this.validator.toString();
    }
}

