/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.tabs;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.tabs.AjaxTabbedPanel;
import org.apache.wicket.extensions.markup.html.tabs.TabbedPanel;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.jetbrains.annotations.Nullable;
import org.ujorm.wicket.CssAppender;
import org.ujorm.wicket.component.tabs.UjoTab;

public class UjoTabbedPanel<T extends UjoTab>
extends AjaxTabbedPanel<T> {
    private final String indexKey = ((Object)((Object)this)).getClass().getName() + ":" + this.getPath() + ".tabIndex.";

    public UjoTabbedPanel(String id, List<T> tabs) {
        this(id, tabs, null);
    }

    public UjoTabbedPanel(String id, List<T> tabs, IModel<Integer> model) {
        super(id, tabs, model);
        this.setSelectedTab(this.getDefaultSelectedTab());
    }

    protected void onAjaxUpdate(AjaxRequestTarget target) {
        this.setDefaultSelectedTab(this.getSelectedTab());
    }

    @Deprecated
    public final void selectedTab(Class<? extends UjoTab> tab, AjaxRequestTarget target) {
        this.selectTab(tab, target);
    }

    public final void selectTab(int tab, AjaxRequestTarget target) {
        this.setSelectedTab(tab);
        target.add(new Component[]{this});
    }

    public final void selectTab(Class<? extends UjoTab> tab, @Nullable AjaxRequestTarget target) {
        List tabs = this.getTabs();
        int max = tabs.size();
        for (int i = 0; i < max; ++i) {
            if (!tab.isAssignableFrom(((UjoTab)((Object)tabs.get(i))).getPanelClass())) continue;
            this.setSelectedTab(i);
            break;
        }
        if (target != null) {
            target.add(new Component[]{this});
        }
    }

    public void selectNextTab(boolean next, AjaxRequestTarget target) {
        int i = this.getSelectedTab() + (next ? 1 : -1);
        if (i >= this.getTabSize()) {
            i = this.getTabSize() - 1;
        }
        if (i < 0) {
            i = 0;
        }
        this.setSelectedTab(i);
        target.add(new Component[]{this});
    }

    public final int getTabSize() {
        return this.getTabs().size();
    }

    public final boolean isLastSelectedTab(boolean last) {
        return this.getSelectedTab() == (last ? this.getTabSize() - 1 : 0);
    }

    public final TabbedPanel<T> setSelectedTab(int index) {
        TabbedPanel result = super.setSelectedTab(index);
        Component panel = super.get("panel");
        panel.add(new Behavior[]{new CssAppender(((UjoTab)((Object)this.getTabs().get(index))).getCssClass())});
        return result;
    }

    protected final int getDefaultSelectedTab() {
        Serializable result = this.getSession().getAttribute(this.indexKey);
        return result instanceof Integer ? (Integer)result : 0;
    }

    protected void setDefaultSelectedTab(Integer index) {
        this.getSession().setAttribute(this.indexKey, (Serializable)index);
    }

    protected WebMarkupContainer newLink(String linkId, int index) {
        WebMarkupContainer result = super.newLink(linkId, index);
        String cssClass = ((UjoTab)((Object)this.getTabs().get(index))).getCssClass();
        if (cssClass != null) {
            result.add(new Behavior[]{new CssAppender(cssClass)});
        }
        return result;
    }

    public WebMarkupContainer getSelectedTabPanel() {
        return (WebMarkupContainer)this.get("panel");
    }
}

