/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.abyss;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.impl.AbstractScatterSearch;
import org.uma.jmetal.algorithm.multiobjective.abyss.util.MarkAttribute;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.LocalSearchOperator;
import org.uma.jmetal.problem.ConstrainedProblem;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.SolutionUtils;
import org.uma.jmetal.util.archive.Archive;
import org.uma.jmetal.util.archive.impl.CrowdingDistanceArchive;
import org.uma.jmetal.util.comparator.CrowdingDistanceComparator;
import org.uma.jmetal.util.comparator.DominanceComparator;
import org.uma.jmetal.util.comparator.EqualSolutionsComparator;
import org.uma.jmetal.util.comparator.StrengthFitnessComparator;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.solutionattribute.impl.DistanceToSolutionListAttribute;
import org.uma.jmetal.util.solutionattribute.impl.StrengthRawFitness;

public class ABYSS
extends AbstractScatterSearch<DoubleSolution, List<DoubleSolution>> {
    protected final int maxEvaluations;
    protected final Problem<DoubleSolution> problem;
    protected final int referenceSet1Size;
    protected final int referenceSet2Size;
    protected List<DoubleSolution> referenceSet1;
    protected List<DoubleSolution> referenceSet2;
    protected final int archiveSize;
    protected Archive<DoubleSolution> archive;
    protected LocalSearchOperator<DoubleSolution> localSearch;
    protected CrossoverOperator<DoubleSolution> crossover;
    protected int evaluations;
    protected JMetalRandom randomGenerator;
    protected int numberOfSubRanges;
    protected int[] sumOfFrequencyValues;
    protected int[] sumOfReverseFrequencyValues;
    protected int[][] frequency;
    protected int[][] reverseFrequency;
    protected StrengthRawFitness strengthRawFitness;
    protected Comparator<Solution> fitnessComparator;
    protected MarkAttribute marked;
    protected DistanceToSolutionListAttribute distanceToSolutionListAttribute;
    protected Comparator<Solution> dominanceComparator;
    protected Comparator<Solution> equalComparator;
    protected Comparator<Solution> crowdingDistanceComparator;

    public ABYSS(DoubleProblem problem, int maxEvaluations, int populationSize, int referenceSet1Size, int referenceSet2Size, int archiveSize, Archive<DoubleSolution> archive, LocalSearchOperator<DoubleSolution> localSearch, CrossoverOperator<DoubleSolution> crossoverOperator, int numberOfSubRanges) {
        this.setPopulationSize(populationSize);
        this.problem = problem;
        this.maxEvaluations = maxEvaluations;
        this.referenceSet1Size = referenceSet1Size;
        this.referenceSet2Size = referenceSet2Size;
        this.archiveSize = archiveSize;
        this.archive = archive;
        this.localSearch = localSearch;
        this.crossover = crossoverOperator;
        this.referenceSet1 = new ArrayList<DoubleSolution>(referenceSet1Size);
        this.referenceSet2 = new ArrayList<DoubleSolution>(referenceSet2Size);
        this.numberOfSubRanges = numberOfSubRanges;
        this.randomGenerator = JMetalRandom.getInstance();
        this.sumOfFrequencyValues = new int[problem.getNumberOfVariables()];
        this.sumOfReverseFrequencyValues = new int[problem.getNumberOfVariables()];
        this.frequency = new int[numberOfSubRanges][problem.getNumberOfVariables()];
        this.reverseFrequency = new int[numberOfSubRanges][problem.getNumberOfVariables()];
        this.strengthRawFitness = new StrengthRawFitness();
        this.fitnessComparator = new StrengthFitnessComparator();
        this.marked = new MarkAttribute();
        this.distanceToSolutionListAttribute = new DistanceToSolutionListAttribute();
        this.crowdingDistanceComparator = new CrowdingDistanceComparator();
        this.dominanceComparator = new DominanceComparator();
        this.equalComparator = new EqualSolutionsComparator();
        this.evaluations = 0;
    }

    public boolean isStoppingConditionReached() {
        return this.evaluations >= this.maxEvaluations;
    }

    public DoubleSolution improvement(DoubleSolution solution) {
        DoubleSolution improvedSolution = (DoubleSolution)this.localSearch.execute((Object)solution);
        this.evaluations += this.localSearch.getEvaluations();
        return improvedSolution;
    }

    public List<DoubleSolution> getResult() {
        return this.archive.getSolutionList();
    }

    public DoubleSolution diversificationGeneration() {
        DoubleSolution solution = (DoubleSolution)this.problem.createSolution();
        for (int i = 0; i < this.problem.getNumberOfVariables(); ++i) {
            double value;
            int range;
            this.sumOfReverseFrequencyValues[i] = 0;
            for (int j = 0; j < this.numberOfSubRanges; ++j) {
                this.reverseFrequency[j][i] = this.sumOfFrequencyValues[i] - this.frequency[j][i];
                int n = i;
                this.sumOfReverseFrequencyValues[n] = this.sumOfReverseFrequencyValues[n] + this.reverseFrequency[j][i];
            }
            if (this.sumOfReverseFrequencyValues[i] == 0) {
                range = this.randomGenerator.nextInt(0, this.numberOfSubRanges - 1);
            } else {
                value = this.randomGenerator.nextInt(0, this.sumOfReverseFrequencyValues[i] - 1);
                range = 0;
                while (value > (double)this.reverseFrequency[range][i]) {
                    value -= (double)this.reverseFrequency[range][i];
                    ++range;
                }
            }
            int[] nArray = this.frequency[range];
            int n = i;
            nArray[n] = nArray[n] + 1;
            int n2 = i;
            this.sumOfFrequencyValues[n2] = this.sumOfFrequencyValues[n2] + 1;
            double low = ((DoubleProblem)this.problem).getLowerBound(i) + (double)range * (((DoubleProblem)this.problem).getUpperBound(i) - ((DoubleProblem)this.problem).getLowerBound(i)) / (double)this.numberOfSubRanges;
            double high = low + (((DoubleProblem)this.problem).getUpperBound(i) - ((DoubleProblem)this.problem).getLowerBound(i)) / (double)this.numberOfSubRanges;
            value = this.randomGenerator.nextDouble(low, high);
            solution.setVariableValue(i, (Object)value);
        }
        this.problem.evaluate((Solution)solution);
        ++this.evaluations;
        return solution;
    }

    public void referenceSetUpdate() {
        this.buildNewReferenceSet1();
        this.buildNewReferenceSet2();
    }

    public void referenceSetUpdate(DoubleSolution solution) {
        if (this.refSet1Test(solution)) {
            for (int indSet2 = 0; indSet2 < this.referenceSet2.size(); ++indSet2) {
                DoubleSolution auxSolution;
                double aux = SolutionUtils.distanceBetweenSolutions((DoubleSolution)solution, (DoubleSolution)this.referenceSet2.get(indSet2));
                if (!(aux < (Double)this.distanceToSolutionListAttribute.getAttribute((Solution)(auxSolution = this.referenceSet2.get(indSet2))))) continue;
                this.distanceToSolutionListAttribute.setAttribute((Solution)auxSolution, (Object)aux);
            }
        } else {
            this.refSet2Test(solution);
        }
    }

    public void buildNewReferenceSet1() {
        this.strengthRawFitness.computeDensityEstimator(this.getPopulation());
        Collections.sort(this.getPopulation(), this.fitnessComparator);
        for (int i = 0; i < this.referenceSet1Size; ++i) {
            DoubleSolution individual = (DoubleSolution)this.getPopulation().get(0);
            this.getPopulation().remove(0);
            this.marked.setAttribute((Solution)individual, false);
            this.referenceSet1.add(individual);
        }
    }

    public void buildNewReferenceSet2() {
        for (int i = 0; i < this.getPopulation().size(); ++i) {
            DoubleSolution individual = (DoubleSolution)this.getPopulation().get(i);
            double distanceAux = SolutionUtils.distanceToSolutionListInSolutionSpace((DoubleSolution)individual, this.referenceSet1);
            this.distanceToSolutionListAttribute.setAttribute((Solution)individual, (Object)distanceAux);
        }
        int size = this.referenceSet2Size;
        if (this.getPopulation().size() < this.referenceSet2Size) {
            size = this.getPopulation().size();
        }
        for (int i = 0; i < size; ++i) {
            int j;
            double maxMinimum = 0.0;
            int index = 0;
            for (int j2 = 0; j2 < this.getPopulation().size(); ++j2) {
                DoubleSolution auxSolution = (DoubleSolution)this.getPopulation().get(j2);
                if (!((Double)this.distanceToSolutionListAttribute.getAttribute((Solution)auxSolution) > maxMinimum)) continue;
                maxMinimum = (Double)this.distanceToSolutionListAttribute.getAttribute((Solution)auxSolution);
                index = j2;
            }
            DoubleSolution individual = (DoubleSolution)this.getPopulation().get(index);
            this.getPopulation().remove(index);
            for (j = 0; j < this.getPopulation().size(); ++j) {
                double aux = SolutionUtils.distanceBetweenSolutions((DoubleSolution)((DoubleSolution)this.getPopulation().get(j)), (DoubleSolution)individual);
                if (!(aux < (Double)this.distanceToSolutionListAttribute.getAttribute((Solution)individual))) continue;
                Solution auxSolution = (Solution)this.getPopulation().get(j);
                this.distanceToSolutionListAttribute.setAttribute(auxSolution, (Object)aux);
            }
            this.marked.setAttribute((Solution)individual, false);
            this.referenceSet2.add(individual);
            for (j = 0; j < this.referenceSet2.size(); ++j) {
                for (int k = 0; k < this.referenceSet2.size(); ++k) {
                    Solution auxSolution;
                    double aux;
                    if (i == j || !((aux = SolutionUtils.distanceBetweenSolutions((DoubleSolution)this.referenceSet2.get(j), (DoubleSolution)this.referenceSet2.get(k))) < (Double)this.distanceToSolutionListAttribute.getAttribute(auxSolution = (Solution)this.referenceSet2.get(j)))) continue;
                    this.distanceToSolutionListAttribute.setAttribute(auxSolution, (Object)aux);
                }
            }
        }
    }

    public boolean refSet1Test(DoubleSolution solution) {
        boolean dominated = false;
        int i = 0;
        while (i < this.referenceSet1.size()) {
            int flag = this.dominanceComparator.compare((Solution)solution, (Solution)this.referenceSet1.get(i));
            if (flag == -1) {
                this.referenceSet1.remove(i);
                continue;
            }
            if (flag == 1) {
                dominated = true;
                ++i;
                continue;
            }
            flag = this.equalComparator.compare((Solution)solution, (Solution)this.referenceSet1.get(i));
            if (flag == 0) {
                return true;
            }
            ++i;
        }
        if (!dominated) {
            this.marked.setAttribute((Solution)solution, false);
            if (this.referenceSet1.size() < this.referenceSet1Size) {
                this.referenceSet1.add(solution);
            } else {
                this.archive.add((Solution)solution);
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean refSet2Test(DoubleSolution solution) {
        if (this.referenceSet2.size() < this.referenceSet2Size) {
            double solutionAux = SolutionUtils.distanceToSolutionListInSolutionSpace((DoubleSolution)solution, this.referenceSet1);
            this.distanceToSolutionListAttribute.setAttribute((Solution)solution, (Object)solutionAux);
            double aux = SolutionUtils.distanceToSolutionListInSolutionSpace((DoubleSolution)solution, this.referenceSet2);
            if (aux < (Double)this.distanceToSolutionListAttribute.getAttribute((Solution)solution)) {
                this.distanceToSolutionListAttribute.setAttribute((Solution)solution, (Object)aux);
            }
            this.referenceSet2.add(solution);
            return true;
        }
        double auxDistance = SolutionUtils.distanceToSolutionListInSolutionSpace((DoubleSolution)solution, this.referenceSet1);
        this.distanceToSolutionListAttribute.setAttribute((Solution)solution, (Object)auxDistance);
        double aux = SolutionUtils.distanceToSolutionListInSolutionSpace((DoubleSolution)solution, this.referenceSet2);
        if (aux < (Double)this.distanceToSolutionListAttribute.getAttribute((Solution)solution)) {
            this.distanceToSolutionListAttribute.setAttribute((Solution)solution, (Object)aux);
        }
        double worst = 0.0;
        int index = 0;
        for (int i = 0; i < this.referenceSet2.size(); ++i) {
            DoubleSolution auxSolution = this.referenceSet2.get(i);
            aux = (Double)this.distanceToSolutionListAttribute.getAttribute((Solution)auxSolution);
            if (!(aux > worst)) continue;
            worst = aux;
            index = i;
        }
        double auxDist = (Double)this.distanceToSolutionListAttribute.getAttribute((Solution)solution);
        if (auxDist < worst) {
            this.referenceSet2.remove(index);
            for (int j = 0; j < this.referenceSet2.size(); ++j) {
                aux = SolutionUtils.distanceBetweenSolutions((DoubleSolution)this.referenceSet2.get(j), (DoubleSolution)solution);
                if (!(aux < (Double)this.distanceToSolutionListAttribute.getAttribute((Solution)this.referenceSet2.get(j)))) continue;
                this.distanceToSolutionListAttribute.setAttribute((Solution)this.referenceSet2.get(j), (Object)aux);
            }
            this.marked.setAttribute((Solution)solution, false);
            this.referenceSet2.add(solution);
            return true;
        }
        return false;
    }

    public boolean restartConditionIsFulfilled(List<DoubleSolution> combinedSolutions) {
        return combinedSolutions.isEmpty();
    }

    public List<List<DoubleSolution>> subsetGeneration() {
        List<List<DoubleSolution>> solutionGroupsList = this.generatePairsFromSolutionList(this.referenceSet1);
        solutionGroupsList.addAll(this.generatePairsFromSolutionList(this.referenceSet2));
        return solutionGroupsList;
    }

    public List<List<DoubleSolution>> generatePairsFromSolutionList(List<DoubleSolution> solutionList) {
        ArrayList<List<DoubleSolution>> subset = new ArrayList<List<DoubleSolution>>();
        for (int i = 0; i < solutionList.size(); ++i) {
            DoubleSolution solution1 = solutionList.get(i);
            for (int j = i + 1; j < solutionList.size(); ++j) {
                DoubleSolution solution2 = solutionList.get(j);
                if (((Boolean)this.marked.getAttribute((Solution)solution1)).booleanValue() && ((Boolean)this.marked.getAttribute((Solution)solution2)).booleanValue()) continue;
                ArrayList<DoubleSolution> pair = new ArrayList<DoubleSolution>(2);
                pair.add(solution1);
                pair.add(solution2);
                subset.add(pair);
                this.marked.setAttribute((Solution)solutionList.get(i), true);
                this.marked.setAttribute((Solution)solutionList.get(j), true);
            }
        }
        return subset;
    }

    public List<DoubleSolution> solutionCombination(List<List<DoubleSolution>> solutionList) {
        ArrayList<DoubleSolution> resultList = new ArrayList<DoubleSolution>();
        for (List<DoubleSolution> pair : solutionList) {
            List offspring = (List)this.crossover.execute(pair);
            if (this.problem instanceof ConstrainedProblem) {
                ((ConstrainedProblem)this.problem).evaluateConstraints((Solution)offspring.get(0));
                ((ConstrainedProblem)this.problem).evaluateConstraints((Solution)offspring.get(1));
            }
            this.problem.evaluate((Solution)offspring.get(0));
            this.problem.evaluate((Solution)offspring.get(1));
            this.evaluations += 2;
            resultList.add((DoubleSolution)offspring.get(0));
            resultList.add((DoubleSolution)offspring.get(1));
        }
        return resultList;
    }

    public void restart() {
        this.getPopulation().clear();
        this.addReferenceSet1ToPopulation();
        this.updatePopulationWithArchive();
        this.fillPopulationWithRandomSolutions();
    }

    private void addReferenceSet1ToPopulation() {
        for (int i = 0; i < this.referenceSet1.size(); ++i) {
            DoubleSolution solution = this.referenceSet1.get(i);
            solution = this.improvement(solution);
            this.marked.setAttribute((Solution)solution, false);
            this.getPopulation().add(solution);
        }
        this.referenceSet1.clear();
        this.referenceSet2.clear();
    }

    private void updatePopulationWithArchive() {
        CrowdingDistanceArchive crowdingArchive = (CrowdingDistanceArchive)this.archive;
        crowdingArchive.computeDistance();
        Collections.sort(crowdingArchive.getSolutionList(), this.crowdingDistanceComparator);
        int insert = this.getPopulationSize() / 2;
        if (insert > crowdingArchive.getSolutionList().size()) {
            insert = crowdingArchive.getSolutionList().size();
        }
        if (insert > this.getPopulationSize() - this.getPopulation().size()) {
            insert = this.getPopulationSize() - this.getPopulation().size();
        }
        for (int i = 0; i < insert; ++i) {
            DoubleSolution solution = (DoubleSolution)((DoubleSolution)crowdingArchive.getSolutionList().get(i)).copy();
            this.marked.setAttribute((Solution)solution, false);
            this.getPopulation().add(solution);
        }
    }

    private void fillPopulationWithRandomSolutions() {
        while (this.getPopulation().size() < this.getPopulationSize()) {
            DoubleSolution solution = this.diversificationGeneration();
            if (this.problem instanceof ConstrainedProblem) {
                ((ConstrainedProblem)this.problem).evaluateConstraints((Solution)solution);
            }
            this.problem.evaluate((Solution)solution);
            ++this.evaluations;
            solution = this.improvement(solution);
            this.marked.setAttribute((Solution)solution, false);
            this.getPopulation().add(solution);
        }
    }
}

