/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.gde3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.uma.jmetal.algorithm.impl.AbstractDifferentialEvolution;
import org.uma.jmetal.operator.impl.crossover.DifferentialEvolutionCrossover;
import org.uma.jmetal.operator.impl.selection.DifferentialEvolutionSelection;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.comparator.CrowdingDistanceComparator;
import org.uma.jmetal.util.comparator.DominanceComparator;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.solutionattribute.DensityEstimator;
import org.uma.jmetal.util.solutionattribute.Ranking;
import org.uma.jmetal.util.solutionattribute.impl.CrowdingDistance;
import org.uma.jmetal.util.solutionattribute.impl.DominanceRanking;

public class GDE3
extends AbstractDifferentialEvolution<List<DoubleSolution>> {
    private DoubleProblem problem;
    protected int populationSize;
    protected int maxIterations;
    protected int iterations;
    protected Comparator<DoubleSolution> dominanceComparator;
    protected Ranking<DoubleSolution> ranking;
    protected DensityEstimator<DoubleSolution> crowdingDistance;
    protected SolutionListEvaluator<DoubleSolution> evaluator;

    public GDE3(DoubleProblem problem, int populationSize, int maxIterations, DifferentialEvolutionSelection selection, DifferentialEvolutionCrossover crossover, SolutionListEvaluator<DoubleSolution> evaluator) {
        this.problem = problem;
        this.populationSize = populationSize;
        this.maxIterations = maxIterations;
        this.crossoverOperator = crossover;
        this.selectionOperator = selection;
        this.dominanceComparator = new DominanceComparator();
        this.ranking = new DominanceRanking();
        this.crowdingDistance = new CrowdingDistance();
        this.evaluator = evaluator;
    }

    protected void initProgress() {
        this.iterations = 1;
    }

    protected void updateProgress() {
        ++this.iterations;
    }

    protected boolean isStoppingConditionReached() {
        return this.iterations >= this.maxIterations;
    }

    protected List<DoubleSolution> createInitialPopulation() {
        ArrayList<DoubleSolution> population = new ArrayList<DoubleSolution>(this.populationSize);
        for (int i = 0; i < this.populationSize; ++i) {
            DoubleSolution newIndividual = (DoubleSolution)this.problem.createSolution();
            population.add(newIndividual);
        }
        return population;
    }

    protected List<DoubleSolution> evaluatePopulation(List<DoubleSolution> population) {
        List pop = this.evaluator.evaluate(population, (Problem)this.problem);
        return pop;
    }

    protected List<DoubleSolution> selection(List<DoubleSolution> population) {
        LinkedList<DoubleSolution> matingPopulation = new LinkedList<DoubleSolution>();
        for (int i = 0; i < this.populationSize; ++i) {
            this.selectionOperator.setIndex(i);
            List parents = this.selectionOperator.execute(population);
            matingPopulation.addAll(parents);
        }
        return matingPopulation;
    }

    protected List<DoubleSolution> reproduction(List<DoubleSolution> matingPopulation) {
        ArrayList<DoubleSolution> offspringPopulation = new ArrayList<DoubleSolution>();
        for (int i = 0; i < this.populationSize; ++i) {
            this.crossoverOperator.setCurrentSolution((DoubleSolution)this.getPopulation().get(i));
            ArrayList<DoubleSolution> parents = new ArrayList<DoubleSolution>(3);
            for (int j = 0; j < 3; ++j) {
                parents.add(matingPopulation.get(0));
                matingPopulation.remove(0);
            }
            this.crossoverOperator.setCurrentSolution((DoubleSolution)this.getPopulation().get(i));
            List children = this.crossoverOperator.execute(parents);
            offspringPopulation.add((DoubleSolution)children.get(0));
        }
        return offspringPopulation;
    }

    protected List<DoubleSolution> replacement(List<DoubleSolution> population, List<DoubleSolution> offspringPopulation) {
        ArrayList<DoubleSolution> tmpList = new ArrayList<DoubleSolution>();
        for (int i = 0; i < this.populationSize; ++i) {
            DoubleSolution child = offspringPopulation.get(i);
            int result = this.dominanceComparator.compare(population.get(i), child);
            if (result == -1) {
                tmpList.add(population.get(i));
                continue;
            }
            if (result == 1) {
                tmpList.add(child);
                continue;
            }
            tmpList.add(child);
            tmpList.add(population.get(i));
        }
        Ranking<DoubleSolution> ranking = this.computeRanking(tmpList);
        List<DoubleSolution> pop = this.crowdingDistanceSelection(ranking);
        return pop;
    }

    public List<DoubleSolution> getResult() {
        return this.getNonDominatedSolutions(this.getPopulation());
    }

    protected Ranking<DoubleSolution> computeRanking(List<DoubleSolution> solutionList) {
        DominanceRanking ranking = new DominanceRanking();
        ranking.computeRanking(solutionList);
        return ranking;
    }

    protected List<DoubleSolution> crowdingDistanceSelection(Ranking<DoubleSolution> ranking) {
        CrowdingDistance crowdingDistance = new CrowdingDistance();
        ArrayList<DoubleSolution> population = new ArrayList<DoubleSolution>(this.populationSize);
        int rankingIndex = 0;
        while (this.populationIsNotFull(population)) {
            if (this.subfrontFillsIntoThePopulation(ranking, rankingIndex, population)) {
                this.addRankedSolutionsToPopulation(ranking, rankingIndex, population);
                ++rankingIndex;
                continue;
            }
            crowdingDistance.computeDensityEstimator(ranking.getSubfront(rankingIndex));
            this.addLastRankedSolutionsToPopulation(ranking, rankingIndex, population);
        }
        return population;
    }

    protected boolean populationIsNotFull(List<DoubleSolution> population) {
        return population.size() < this.populationSize;
    }

    protected boolean subfrontFillsIntoThePopulation(Ranking<DoubleSolution> ranking, int rank, List<DoubleSolution> population) {
        return ranking.getSubfront(rank).size() < this.populationSize - population.size();
    }

    protected void addRankedSolutionsToPopulation(Ranking<DoubleSolution> ranking, int rank, List<DoubleSolution> population) {
        List front = ranking.getSubfront(rank);
        for (int i = 0; i < front.size(); ++i) {
            population.add((DoubleSolution)front.get(i));
        }
    }

    protected void addLastRankedSolutionsToPopulation(Ranking<DoubleSolution> ranking, int rank, List<DoubleSolution> population) {
        List currentRankedFront = ranking.getSubfront(rank);
        Collections.sort(currentRankedFront, new CrowdingDistanceComparator());
        int i = 0;
        while (population.size() < this.populationSize) {
            population.add((DoubleSolution)currentRankedFront.get(i));
            ++i;
        }
    }

    protected List<DoubleSolution> getNonDominatedSolutions(List<DoubleSolution> solutionList) {
        return SolutionListUtils.getNondominatedSolutions(solutionList);
    }
}

