/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.gde3;

import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.gde3.GDE3;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.operator.impl.crossover.DifferentialEvolutionCrossover;
import org.uma.jmetal.operator.impl.selection.DifferentialEvolutionSelection;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.AlgorithmBuilder;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;

public class GDE3Builder
implements AlgorithmBuilder<GDE3> {
    private DoubleProblem problem;
    protected int populationSize;
    protected int maxIterations;
    protected DifferentialEvolutionCrossover crossoverOperator;
    protected DifferentialEvolutionSelection selectionOperator;
    protected SolutionListEvaluator<DoubleSolution> evaluator;

    public GDE3Builder(DoubleProblem problem) {
        this.problem = problem;
        this.maxIterations = 250;
        this.populationSize = 100;
        this.selectionOperator = new DifferentialEvolutionSelection();
        this.crossoverOperator = new DifferentialEvolutionCrossover();
        this.evaluator = new SequentialSolutionListEvaluator();
    }

    public GDE3Builder setPopulationSize(int populationSize) {
        this.populationSize = populationSize;
        return this;
    }

    public GDE3Builder setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
        return this;
    }

    public GDE3Builder setCrossover(DifferentialEvolutionCrossover crossover) {
        this.crossoverOperator = crossover;
        return this;
    }

    public GDE3Builder setSelection(DifferentialEvolutionSelection selection) {
        this.selectionOperator = selection;
        return this;
    }

    public GDE3Builder setSolutionSetEvaluator(SolutionListEvaluator<DoubleSolution> evaluator) {
        this.evaluator = evaluator;
        return this;
    }

    public GDE3 build() {
        return new GDE3(this.problem, this.populationSize, this.maxIterations, this.selectionOperator, this.crossoverOperator, this.evaluator);
    }

    public CrossoverOperator<DoubleSolution> getCrossoverOperator() {
        return this.crossoverOperator;
    }

    public SelectionOperator<List<DoubleSolution>, List<DoubleSolution>> getSelectionOperator() {
        return this.selectionOperator;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }
}

