/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.mochc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.impl.AbstractEvolutionaryAlgorithm;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.problem.BinaryProblem;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.BinarySolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.binarySet.BinarySet;
import org.uma.jmetal.util.comparator.CrowdingDistanceComparator;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;

public class MOCHC
extends AbstractEvolutionaryAlgorithm<BinarySolution, List<BinarySolution>> {
    private BinaryProblem problem;
    private int populationSize;
    private int maxEvaluations;
    private int convergenceValue;
    private double preservedPopulation;
    private double initialConvergenceCount;
    private CrossoverOperator<BinarySolution> crossover;
    private MutationOperator<BinarySolution> cataclysmicMutation;
    private SelectionOperator<List<BinarySolution>, List<BinarySolution>> newGenerationSelection;
    private SelectionOperator<List<BinarySolution>, BinarySolution> parentSelection;
    private int evaluations;
    private int minimumDistance;
    private int size;
    private Comparator<BinarySolution> comparator;
    private SolutionListEvaluator<BinarySolution> evaluator;

    public MOCHC(BinaryProblem problem, int populationSize, int maxEvaluations, int convergenceValue, double preservedPopulation, double initialConvergenceCount, CrossoverOperator<BinarySolution> crossoverOperator, MutationOperator<BinarySolution> cataclysmicMutation, SelectionOperator<List<BinarySolution>, List<BinarySolution>> newGenerationSelection, SelectionOperator<List<BinarySolution>, BinarySolution> parentSelection, SolutionListEvaluator<BinarySolution> evaluator) {
        this.problem = problem;
        this.populationSize = populationSize;
        this.maxEvaluations = maxEvaluations;
        this.convergenceValue = convergenceValue;
        this.preservedPopulation = preservedPopulation;
        this.initialConvergenceCount = initialConvergenceCount;
        this.crossover = crossoverOperator;
        this.cataclysmicMutation = cataclysmicMutation;
        this.newGenerationSelection = newGenerationSelection;
        this.parentSelection = parentSelection;
        this.evaluator = evaluator;
        for (int i = 0; i < problem.getNumberOfVariables(); ++i) {
            this.size += problem.getNumberOfBits(i);
        }
        this.minimumDistance = (int)Math.floor(this.initialConvergenceCount * (double)this.size);
        this.comparator = new CrowdingDistanceComparator();
    }

    protected void initProgress() {
        this.evaluations = this.populationSize;
    }

    protected void updateProgress() {
        this.evaluations += this.populationSize;
    }

    protected boolean isStoppingConditionReached() {
        return this.evaluations >= this.maxEvaluations;
    }

    protected List<BinarySolution> createInitialPopulation() {
        ArrayList<BinarySolution> population = new ArrayList<BinarySolution>(this.populationSize);
        for (int i = 0; i < this.populationSize; ++i) {
            BinarySolution newIndividual = (BinarySolution)this.problem.createSolution();
            population.add(newIndividual);
        }
        return population;
    }

    protected List<BinarySolution> evaluatePopulation(List<BinarySolution> population) {
        population = this.evaluator.evaluate(population, (Problem)this.problem);
        return population;
    }

    protected List<BinarySolution> selection(List<BinarySolution> population) {
        ArrayList<BinarySolution> matingPopulation = new ArrayList<BinarySolution>(population.size());
        for (int i = 0; i < this.populationSize; ++i) {
            BinarySolution solution = (BinarySolution)this.parentSelection.execute(population);
            matingPopulation.add(solution);
        }
        return matingPopulation;
    }

    protected List<BinarySolution> reproduction(List<BinarySolution> matingPopulation) {
        ArrayList<BinarySolution> offspringPopulation = new ArrayList<BinarySolution>();
        for (int i = 0; i < matingPopulation.size(); i += 2) {
            ArrayList<BinarySolution> parents = new ArrayList<BinarySolution>(2);
            parents.add(matingPopulation.get(i));
            parents.add(matingPopulation.get(i + 1));
            if (this.hammingDistance((BinarySolution)parents.get(0), (BinarySolution)parents.get(1)) < this.minimumDistance) continue;
            List offspring = (List)this.crossover.execute(parents);
            offspringPopulation.add((BinarySolution)offspring.get(0));
            offspringPopulation.add((BinarySolution)offspring.get(1));
        }
        return offspringPopulation;
    }

    protected List<BinarySolution> replacement(List<BinarySolution> population, List<BinarySolution> offspringPopulation) {
        ArrayList<BinarySolution> union = new ArrayList<BinarySolution>();
        union.addAll(population);
        union.addAll(offspringPopulation);
        ArrayList<BinarySolution> newPopulation = (ArrayList<BinarySolution>)this.newGenerationSelection.execute(union);
        if (this.solutionSetsAreEquals(population, (List<BinarySolution>)newPopulation)) {
            --this.minimumDistance;
        }
        if (this.minimumDistance <= -this.convergenceValue) {
            int i;
            this.minimumDistance = (int)(1.0 / (double)this.size * (1.0 - 1.0 / (double)this.size) * (double)this.size);
            int preserve = (int)Math.floor(this.preservedPopulation * (double)this.populationSize);
            newPopulation = new ArrayList<BinarySolution>(this.populationSize);
            Collections.sort(population, this.comparator);
            for (i = 0; i < preserve; ++i) {
                newPopulation.add((BinarySolution)population.get(i).copy());
            }
            for (i = preserve; i < this.populationSize; ++i) {
                BinarySolution solution = (BinarySolution)population.get(i).copy();
                this.cataclysmicMutation.execute((Object)solution);
                newPopulation.add(solution);
            }
        }
        return newPopulation;
    }

    public List<BinarySolution> getResult() {
        return SolutionListUtils.getNondominatedSolutions((List)this.getPopulation());
    }

    public boolean solutionSetsAreEquals(List<BinarySolution> solutionSet, List<BinarySolution> newSolutionSet) {
        for (int i = 0; i < solutionSet.size(); ++i) {
            boolean found = false;
            for (int j = 0; j < newSolutionSet.size(); ++j) {
                if (!solutionSet.get(i).equals(newSolutionSet.get(j))) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private int hammingDistance(BinarySolution solutionOne, BinarySolution solutionTwo) {
        int distance = 0;
        for (int i = 0; i < this.problem.getNumberOfVariables(); ++i) {
            distance += this.hammingDistance((BinarySet)solutionOne.getVariableValue(i), (BinarySet)solutionTwo.getVariableValue(i));
        }
        return distance;
    }

    private int hammingDistance(BinarySet bitSet1, BinarySet bitSet2) {
        if (bitSet1.getBinarySetLength() != bitSet2.getBinarySetLength()) {
            throw new JMetalException("The bitsets have different length: " + bitSet1.getBinarySetLength() + ", " + bitSet2.getBinarySetLength());
        }
        int distance = 0;
        for (int i = 0; i < bitSet1.getBinarySetLength(); ++i) {
            if (bitSet1.get(i) == bitSet2.get(i)) continue;
            ++distance;
        }
        return distance;
    }
}

