/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.nsgaii;

import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAII;
import org.uma.jmetal.measure.Measurable;
import org.uma.jmetal.measure.MeasureManager;
import org.uma.jmetal.measure.PullMeasure;
import org.uma.jmetal.measure.PushMeasure;
import org.uma.jmetal.measure.impl.BasicMeasure;
import org.uma.jmetal.measure.impl.CountingMeasure;
import org.uma.jmetal.measure.impl.DurationMeasure;
import org.uma.jmetal.measure.impl.SimpleMeasureManager;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.solutionattribute.Ranking;

public class NSGAIIMeasures<S extends Solution<?>>
extends NSGAII<S>
implements Measurable {
    private CountingMeasure iterations;
    private BasicMeasure<Integer> numberOfFeasibleSolutionsInPopulation;
    private DurationMeasure durationMeasure;
    private SimpleMeasureManager measureManager;
    private BasicMeasure<List<S>> solutionListMeasure;
    private BasicMeasure<Integer> numberOfNonDominatedSolutionsInPopulation;

    public NSGAIIMeasures(Problem<S> problem, int maxIterations, int populationSize, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutationOperator, SelectionOperator<List<S>, S> selectionOperator, SolutionListEvaluator<S> evaluator) {
        super(problem, maxIterations, populationSize, crossoverOperator, mutationOperator, selectionOperator, evaluator);
        this.initMeasures();
    }

    @Override
    protected void initProgress() {
        this.iterations.reset(1L);
    }

    @Override
    protected void updateProgress() {
        this.iterations.increment();
        this.solutionListMeasure.push((Object)this.getPopulation());
    }

    @Override
    protected boolean isStoppingConditionReached() {
        return this.iterations.get() >= (long)this.maxIterations;
    }

    @Override
    protected List<S> evaluatePopulation(List<S> population) {
        population = super.evaluatePopulation(population);
        int countFeasibleSolutions = 0;
        for (Solution solution : population) {
            if (solution.getOverallConstraintViolationDegree() != 0.0) continue;
            ++countFeasibleSolutions;
        }
        if (countFeasibleSolutions > 0) {
            this.numberOfFeasibleSolutionsInPopulation.push((Object)countFeasibleSolutions);
        }
        return population;
    }

    public void run() {
        this.durationMeasure.reset();
        this.durationMeasure.start();
        super.run();
        this.durationMeasure.stop();
    }

    private void initMeasures() {
        this.durationMeasure = new DurationMeasure();
        this.iterations = new CountingMeasure(0L);
        this.numberOfNonDominatedSolutionsInPopulation = new BasicMeasure();
        this.solutionListMeasure = new BasicMeasure();
        this.numberOfFeasibleSolutionsInPopulation = new BasicMeasure();
        this.measureManager = new SimpleMeasureManager();
        this.measureManager.setPullMeasure((Object)"currentExecutionTime", (PullMeasure)this.durationMeasure);
        this.measureManager.setPullMeasure((Object)"currentIteration", (PullMeasure)this.iterations);
        this.measureManager.setPullMeasure((Object)"numberOfNonDominatedSolutionsInPopulation", this.numberOfNonDominatedSolutionsInPopulation);
        this.measureManager.setPushMeasure((Object)"currentPopulation", this.solutionListMeasure);
        this.measureManager.setPushMeasure((Object)"currentIteration", (PushMeasure)this.iterations);
        this.measureManager.setPushMeasure((Object)"numberOfFeasibleSolutionsInPopulation", this.numberOfFeasibleSolutionsInPopulation);
    }

    public MeasureManager getMeasureManager() {
        return this.measureManager;
    }

    @Override
    protected List<S> replacement(List<S> population, List<S> offspringPopulation) {
        List<S> pop = super.replacement(population, offspringPopulation);
        Ranking<S> ranking = this.computeRanking(pop);
        this.numberOfNonDominatedSolutionsInPopulation.set((Object)ranking.getSubfront(0).size());
        return pop;
    }
}

