/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.nsgaiii;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.uma.jmetal.algorithm.impl.AbstractGeneticAlgorithm;
import org.uma.jmetal.algorithm.multiobjective.nsgaiii.EnvironmentalSelectionNSGAIII;
import org.uma.jmetal.algorithm.multiobjective.nsgaiii.NSGAIIIBuilder;
import org.uma.jmetal.algorithm.multiobjective.nsgaiii.ReferencePoint;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.solutionattribute.Ranking;
import org.uma.jmetal.util.solutionattribute.impl.DominanceRanking;

public class NSGAIII<S extends Solution<?>>
extends AbstractGeneticAlgorithm<S, List<S>> {
    protected int evaluations;
    protected int maxEvaluations;
    protected int populationSize;
    protected Problem<S> problem;
    protected SolutionListEvaluator<S> evaluator;
    private Vector<Integer> numberOfDivisions;
    private List<ReferencePoint<S>> referencePoints = new Vector<ReferencePoint<S>>();
    public static NSGAIIIBuilder<?> Builder;

    public NSGAIII() {
    }

    NSGAIII(NSGAIIIBuilder<S> builder) {
        this.problem = builder.problem;
        this.maxEvaluations = builder.maxEvaluations;
        this.crossoverOperator = builder.crossoverOperator;
        this.mutationOperator = builder.mutationOperator;
        this.selectionOperator = builder.selectionOperator;
        this.evaluator = builder.evaluator;
        this.numberOfDivisions = new Vector(1);
        this.numberOfDivisions.add(builder.getDivisions());
        ReferencePoint.generateReferencePoints(this.referencePoints, this.problem.getNumberOfObjectives(), this.numberOfDivisions);
        this.populationSize = this.referencePoints.size();
        while (this.populationSize % 4 > 0) {
            ++this.populationSize;
        }
    }

    protected void initProgress() {
        this.evaluations = this.populationSize;
    }

    protected void updateProgress() {
        this.evaluations += this.populationSize;
    }

    protected boolean isStoppingConditionReached() {
        return this.evaluations >= this.maxEvaluations;
    }

    protected List<S> createInitialPopulation() {
        ArrayList<Solution> population = new ArrayList<Solution>(this.populationSize);
        for (int i = 0; i < this.populationSize; ++i) {
            Solution newIndividual = this.problem.createSolution();
            population.add(newIndividual);
        }
        return population;
    }

    protected List<S> evaluatePopulation(List<S> population) {
        population = this.evaluator.evaluate(population, this.problem);
        return population;
    }

    protected List<S> selection(List<S> population) {
        ArrayList<Solution> matingPopulation = new ArrayList<Solution>(population.size());
        for (int i = 0; i < this.populationSize; ++i) {
            Solution solution = (Solution)this.selectionOperator.execute(population);
            matingPopulation.add(solution);
        }
        return matingPopulation;
    }

    protected List<S> reproduction(List<S> population) {
        ArrayList offspringPopulation = new ArrayList(this.populationSize);
        for (int i = 0; i < this.populationSize; i += 2) {
            ArrayList<S> parents = new ArrayList<S>(2);
            parents.add(population.get(i));
            parents.add(population.get(i + 1));
            List offspring = (List)this.crossoverOperator.execute(parents);
            this.mutationOperator.execute(offspring.get(0));
            this.mutationOperator.execute(offspring.get(1));
            offspringPopulation.add(offspring.get(0));
            offspringPopulation.add(offspring.get(1));
        }
        return offspringPopulation;
    }

    private List<ReferencePoint<S>> getReferencePointsCopy() {
        ArrayList<ReferencePoint<S>> copy = new ArrayList<ReferencePoint<S>>();
        for (ReferencePoint<S> r : this.referencePoints) {
            copy.add(new ReferencePoint<S>(r));
        }
        return copy;
    }

    protected List<S> replacement(List<S> population, List<S> offspringPopulation) {
        ArrayList<S> jointPopulation = new ArrayList<S>();
        jointPopulation.addAll(population);
        jointPopulation.addAll(offspringPopulation);
        Ranking ranking = this.computeRanking(jointPopulation);
        List<Object> pop = new ArrayList();
        ArrayList fronts = new ArrayList();
        int rankingIndex = 0;
        int candidateSolutions = 0;
        while (candidateSolutions < this.populationSize) {
            fronts.add(ranking.getSubfront(rankingIndex));
            candidateSolutions += ranking.getSubfront(rankingIndex).size();
            if (pop.size() + ranking.getSubfront(rankingIndex).size() <= this.populationSize) {
                this.addRankedSolutionsToPopulation(ranking, rankingIndex, pop);
            }
            ++rankingIndex;
        }
        EnvironmentalSelectionNSGAIII selection = new EnvironmentalSelectionNSGAIII.Builder().setNumberOfObjectives(this.problem.getNumberOfObjectives()).setFronts(fronts).setSolutionsToSelect(this.populationSize).setReferencePoints(this.getReferencePointsCopy()).build();
        pop = selection.execute(pop);
        return pop;
    }

    public List<S> getResult() {
        return this.getNonDominatedSolutions(this.getPopulation());
    }

    protected Ranking<S> computeRanking(List<S> solutionList) {
        DominanceRanking ranking = new DominanceRanking();
        ranking.computeRanking(solutionList);
        return ranking;
    }

    protected boolean populationIsNotFull(List<S> population) {
        return population.size() < this.populationSize;
    }

    protected boolean subfrontFillsIntoThePopulation(Ranking<S> ranking, int rank, List<S> population) {
        return ranking.getSubfront(rank).size() < this.populationSize - population.size();
    }

    protected void addRankedSolutionsToPopulation(Ranking<S> ranking, int rank, List<S> population) {
        List front = ranking.getSubfront(rank);
        for (int i = 0; i < front.size(); ++i) {
            population.add(front.get(i));
        }
    }

    protected List<S> getNonDominatedSolutions(List<S> solutionList) {
        return SolutionListUtils.getNondominatedSolutions(solutionList);
    }
}

