/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.pesa2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.uma.jmetal.algorithm.impl.AbstractGeneticAlgorithm;
import org.uma.jmetal.algorithm.multiobjective.pesa2.util.PESA2Selection;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.archive.impl.AdaptiveGridArchive;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;

public class PESA2<S extends Solution<?>>
extends AbstractGeneticAlgorithm<S, List<S>> {
    private int maxEvaluations;
    private int archiveSize;
    private int populationSize;
    private int biSections;
    private int evaluations;
    protected final Problem<S> problem;
    protected SelectionOperator<AdaptiveGridArchive<S>, S> selectionOperator;
    private AdaptiveGridArchive<S> archive;
    protected final SolutionListEvaluator<S> evaluator;

    public PESA2(Problem<S> problem, int maxEvaluations, int populationSize, int archiveSize, int biSections, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutationOperator, SolutionListEvaluator<S> evaluator) {
        this.problem = problem;
        this.maxEvaluations = maxEvaluations;
        this.populationSize = populationSize;
        this.archiveSize = archiveSize;
        this.biSections = biSections;
        this.crossoverOperator = crossoverOperator;
        this.mutationOperator = mutationOperator;
        this.selectionOperator = new PESA2Selection();
        this.evaluator = evaluator;
        this.archive = new AdaptiveGridArchive(archiveSize, biSections, problem.getNumberOfObjectives());
    }

    protected void initProgress() {
        this.evaluations = this.populationSize;
    }

    protected void updateProgress() {
        this.evaluations += this.populationSize;
    }

    protected boolean isStoppingConditionReached() {
        return this.evaluations >= this.maxEvaluations;
    }

    protected List<S> createInitialPopulation() {
        ArrayList<Solution> population = new ArrayList<Solution>(this.populationSize);
        for (int i = 0; i < this.populationSize; ++i) {
            Solution newIndividual = this.problem.createSolution();
            population.add(newIndividual);
        }
        return population;
    }

    protected List<S> evaluatePopulation(List<S> population) {
        population = this.evaluator.evaluate(population, this.problem);
        return population;
    }

    protected List<S> selection(List<S> population) {
        ArrayList<Solution> matingPopulation = new ArrayList<Solution>(this.populationSize);
        for (Solution solution : population) {
            this.archive.add(solution);
        }
        while (matingPopulation.size() < this.populationSize) {
            Solution solution = (Solution)this.selectionOperator.execute(this.archive);
            matingPopulation.add(solution);
        }
        return matingPopulation;
    }

    protected List<S> reproduction(List<S> population) {
        ArrayList offspringPopulation = new ArrayList(this.populationSize);
        for (int i = 0; i < this.populationSize; i += 2) {
            ArrayList<S> parents = new ArrayList<S>(2);
            parents.add(population.get(i));
            parents.add(population.get(i + 1));
            List offspring = (List)this.crossoverOperator.execute(parents);
            this.mutationOperator.execute(offspring.get(0));
            offspringPopulation.add(offspring.get(0));
        }
        return offspringPopulation;
    }

    protected List<S> replacement(List<S> population, List<S> offspringPopulation) {
        for (Solution solution : offspringPopulation) {
            this.archive.add(solution);
        }
        return Collections.emptyList();
    }

    public List<S> getResult() {
        return this.archive.getSolutionList();
    }
}

