/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.smsemoa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.uma.jmetal.algorithm.impl.AbstractGeneticAlgorithm;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.qualityindicator.impl.Hypervolume;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.comparator.HypervolumeContributorComparator;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;
import org.uma.jmetal.util.front.util.FrontUtils;
import org.uma.jmetal.util.point.Point;
import org.uma.jmetal.util.solutionattribute.Ranking;
import org.uma.jmetal.util.solutionattribute.impl.DominanceRanking;
import org.uma.jmetal.util.solutionattribute.impl.HypervolumeContribution;

public class SMSEMOA<S extends Solution<?>>
extends AbstractGeneticAlgorithm<S, List<S>> {
    protected final int maxEvaluations;
    protected final int populationSize;
    protected final double offset;
    protected final Problem<S> problem;
    protected int evaluations;
    private Hypervolume hypervolume;

    public SMSEMOA(Problem<S> problem, int maxEvaluations, int populationSize, double offset, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutationOperator, SelectionOperator<List<S>, S> selectionOperator) {
        this.problem = problem;
        this.maxEvaluations = maxEvaluations;
        this.populationSize = populationSize;
        this.offset = offset;
        this.crossoverOperator = crossoverOperator;
        this.mutationOperator = mutationOperator;
        this.selectionOperator = selectionOperator;
        this.hypervolume = new Hypervolume();
    }

    protected void initProgress() {
        this.evaluations = this.populationSize;
    }

    protected void updateProgress() {
        ++this.evaluations;
    }

    protected boolean isStoppingConditionReached() {
        return this.evaluations >= this.maxEvaluations;
    }

    protected List<S> createInitialPopulation() {
        ArrayList<Solution> population = new ArrayList<Solution>(this.populationSize);
        for (int i = 0; i < this.populationSize; ++i) {
            Solution newIndividual = this.problem.createSolution();
            population.add(newIndividual);
        }
        return population;
    }

    protected List<S> evaluatePopulation(List<S> population) {
        for (int i = 0; i < population.size(); ++i) {
            this.problem.evaluate((Solution)population.get(i));
        }
        return population;
    }

    protected List<S> selection(List<S> population) {
        ArrayList<Solution> matingPopulation = new ArrayList<Solution>(2);
        for (int i = 0; i < 2; ++i) {
            Solution solution = (Solution)this.selectionOperator.execute(population);
            matingPopulation.add(solution);
        }
        return matingPopulation;
    }

    protected List<S> reproduction(List<S> population) {
        ArrayList offspringPopulation = new ArrayList(1);
        ArrayList<S> parents = new ArrayList<S>(2);
        parents.add(population.get(0));
        parents.add(population.get(1));
        List offspring = (List)this.crossoverOperator.execute(parents);
        this.mutationOperator.execute(offspring.get(0));
        offspringPopulation.add(offspring.get(0));
        return offspringPopulation;
    }

    protected List<S> replacement(List<S> population, List<S> offspringPopulation) {
        int i;
        ArrayList<S> jointPopulation = new ArrayList<S>();
        jointPopulation.addAll(population);
        jointPopulation.addAll(offspringPopulation);
        Ranking ranking = this.computeRanking(jointPopulation);
        List lastSubfront = ranking.getSubfront(ranking.getNumberOfSubfronts() - 1);
        lastSubfront = this.computeHypervolumeContribution(lastSubfront, jointPopulation);
        ArrayList<Object> resultPopulation = new ArrayList<Object>();
        for (i = 0; i < ranking.getNumberOfSubfronts() - 1; ++i) {
            for (Solution solution : ranking.getSubfront(i)) {
                resultPopulation.add(solution);
            }
        }
        for (i = 0; i < lastSubfront.size() - 1; ++i) {
            resultPopulation.add(lastSubfront.get(i));
        }
        return resultPopulation;
    }

    public List<S> getResult() {
        return this.getPopulation();
    }

    protected Ranking<S> computeRanking(List<S> solutionList) {
        DominanceRanking ranking = new DominanceRanking();
        ranking.computeRanking(solutionList);
        return ranking;
    }

    private List<S> computeHypervolumeContribution(List<S> lastFront, List<S> solutionList) {
        if (lastFront.size() > 1) {
            ArrayFront subFront = new ArrayFront(lastFront);
            ArrayFront front = new ArrayFront(solutionList);
            double[] maximumValues = FrontUtils.getMaximumValues((Front)front);
            double[] minimumValues = FrontUtils.getMinimumValues((Front)front);
            Front normalizedFront = FrontUtils.getNormalizedFront((Front)subFront, (double[])maximumValues, (double[])minimumValues);
            double[] offsets = new double[maximumValues.length];
            for (int i = 0; i < maximumValues.length; ++i) {
                offsets[i] = this.offset / (maximumValues[i] - minimumValues[i]);
            }
            Front invertedFront = FrontUtils.getInvertedFront((Front)normalizedFront);
            for (int i = 0; i < invertedFront.getNumberOfPoints(); ++i) {
                Point point = invertedFront.getPoint(i);
                for (int j = 0; j < point.getNumberOfDimensions(); ++j) {
                    point.setDimensionValue(j, point.getDimensionValue(j) + offsets[j]);
                }
            }
            HypervolumeContribution hvContribution = new HypervolumeContribution();
            double[] contributions = this.hvContributions(FrontUtils.convertFrontToArray((Front)invertedFront));
            for (int i = 0; i < contributions.length; ++i) {
                hvContribution.setAttribute((Solution)lastFront.get(i), (Object)contributions[i]);
            }
            Collections.sort(lastFront, new HypervolumeContributorComparator());
        }
        return lastFront;
    }

    private double[] hvContributions(double[][] front) {
        int numberOfObjectives = this.problem.getNumberOfObjectives();
        double[] contributions = new double[front.length];
        double[][] frontSubset = new double[front.length - 1][front[0].length];
        LinkedList<double[]> frontCopy = new LinkedList<double[]>();
        Collections.addAll(frontCopy, front);
        double[][] totalFront = (double[][])frontCopy.toArray((T[])frontSubset);
        double totalVolume = this.hypervolume.calculateHypervolume(totalFront, totalFront.length, numberOfObjectives);
        for (int i = 0; i < front.length; ++i) {
            double contribution;
            double[] evaluatedPoint = (double[])frontCopy.remove(i);
            frontSubset = (double[][])frontCopy.toArray((T[])frontSubset);
            double hv = this.hypervolume.calculateHypervolume(frontSubset, frontSubset.length, numberOfObjectives);
            contributions[i] = contribution = totalVolume - hv;
            frontCopy.add(i, evaluatedPoint);
        }
        return contributions;
    }
}

