/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.smsemoa;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.algorithm.impl.AbstractGeneticAlgorithm;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.qualityindicator.hypervolume.Hypervolume;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.solutionattribute.Ranking;
import org.uma.jmetal.util.solutionattribute.impl.DominanceRanking;

public class SMSEMOA2<S extends Solution<?>>
extends AbstractGeneticAlgorithm<S, List<S>> {
    protected final int maxEvaluations;
    protected final int populationSize;
    protected final double offset;
    protected final Problem<S> problem;
    protected int evaluations;
    private Hypervolume hypervolume;

    public SMSEMOA2(Problem<S> problem, int maxEvaluations, int populationSize, double offset, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutationOperator, SelectionOperator<List<S>, S> selectionOperator, Hypervolume hypervolume) {
        this.problem = problem;
        this.maxEvaluations = maxEvaluations;
        this.populationSize = populationSize;
        this.offset = offset;
        this.crossoverOperator = crossoverOperator;
        this.mutationOperator = mutationOperator;
        this.selectionOperator = selectionOperator;
        this.hypervolume = hypervolume;
    }

    protected void initProgress() {
        this.evaluations = this.populationSize;
    }

    protected void updateProgress() {
        ++this.evaluations;
    }

    protected boolean isStoppingConditionReached() {
        return this.evaluations >= this.maxEvaluations;
    }

    protected List<S> createInitialPopulation() {
        ArrayList<Solution> population = new ArrayList<Solution>(this.populationSize);
        for (int i = 0; i < this.populationSize; ++i) {
            Solution newIndividual = this.problem.createSolution();
            population.add(newIndividual);
        }
        return population;
    }

    protected List<S> evaluatePopulation(List<S> population) {
        for (int i = 0; i < population.size(); ++i) {
            this.problem.evaluate((Solution)population.get(i));
        }
        return population;
    }

    protected List<S> selection(List<S> population) {
        ArrayList<Solution> matingPopulation = new ArrayList<Solution>(2);
        for (int i = 0; i < 2; ++i) {
            Solution solution = (Solution)this.selectionOperator.execute(population);
            matingPopulation.add(solution);
        }
        return matingPopulation;
    }

    protected List<S> reproduction(List<S> population) {
        ArrayList offspringPopulation = new ArrayList(1);
        ArrayList<S> parents = new ArrayList<S>(2);
        parents.add(population.get(0));
        parents.add(population.get(1));
        List offspring = (List)this.crossoverOperator.execute(parents);
        this.mutationOperator.execute(offspring.get(0));
        offspringPopulation.add(offspring.get(0));
        return offspringPopulation;
    }

    protected List<S> replacement(List<S> population, List<S> offspringPopulation) {
        int i;
        ArrayList<S> jointPopulation = new ArrayList<S>();
        jointPopulation.addAll(population);
        jointPopulation.addAll(offspringPopulation);
        Ranking ranking = this.computeRanking(jointPopulation);
        List lastSubfront = ranking.getSubfront(ranking.getNumberOfSubfronts() - 1);
        ArrayList<Object> resultPopulation = new ArrayList<Object>();
        for (i = 0; i < ranking.getNumberOfSubfronts() - 1; ++i) {
            for (Solution solution : ranking.getSubfront(i)) {
                resultPopulation.add(solution);
            }
        }
        for (i = 0; i < lastSubfront.size() - 1; ++i) {
            resultPopulation.add(lastSubfront.get(i));
        }
        return resultPopulation;
    }

    public List<S> getResult() {
        return this.getPopulation();
    }

    protected Ranking<S> computeRanking(List<S> solutionList) {
        DominanceRanking ranking = new DominanceRanking();
        ranking.computeRanking(solutionList);
        return ranking;
    }
}

