/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.singleobjective.differentialevolution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.impl.AbstractDifferentialEvolution;
import org.uma.jmetal.operator.impl.crossover.DifferentialEvolutionCrossover;
import org.uma.jmetal.operator.impl.selection.DifferentialEvolutionSelection;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.comparator.ObjectiveComparator;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;

public class DifferentialEvolution
extends AbstractDifferentialEvolution<DoubleSolution> {
    private DoubleProblem problem;
    private int populationSize;
    private int maxEvaluations;
    private SolutionListEvaluator<DoubleSolution> evaluator;
    private Comparator<DoubleSolution> comparator;
    private int evaluations;

    public DifferentialEvolution(DoubleProblem problem, int maxEvaluations, int populationSize, DifferentialEvolutionCrossover crossoverOperator, DifferentialEvolutionSelection selectionOperator, SolutionListEvaluator<DoubleSolution> evaluator) {
        this.problem = problem;
        this.maxEvaluations = maxEvaluations;
        this.populationSize = populationSize;
        this.crossoverOperator = crossoverOperator;
        this.selectionOperator = selectionOperator;
        this.evaluator = evaluator;
        this.comparator = new ObjectiveComparator(0);
    }

    public int getEvaluations() {
        return this.evaluations;
    }

    public void setEvaluations(int evaluations) {
        this.evaluations = evaluations;
    }

    protected void initProgress() {
        this.evaluations = this.populationSize;
    }

    protected void updateProgress() {
        this.evaluations += this.populationSize;
    }

    protected boolean isStoppingConditionReached() {
        return this.evaluations >= this.maxEvaluations;
    }

    protected List<DoubleSolution> createInitialPopulation() {
        ArrayList<DoubleSolution> population = new ArrayList<DoubleSolution>(this.populationSize);
        for (int i = 0; i < this.populationSize; ++i) {
            DoubleSolution newIndividual = (DoubleSolution)this.problem.createSolution();
            population.add(newIndividual);
        }
        return population;
    }

    protected List<DoubleSolution> evaluatePopulation(List<DoubleSolution> population) {
        List pop = this.evaluator.evaluate(population, (Problem)this.problem);
        return pop;
    }

    protected List<DoubleSolution> selection(List<DoubleSolution> population) {
        return population;
    }

    protected List<DoubleSolution> reproduction(List<DoubleSolution> matingPopulation) {
        ArrayList<DoubleSolution> offspringPopulation = new ArrayList<DoubleSolution>();
        for (int i = 0; i < this.populationSize; ++i) {
            this.selectionOperator.setIndex(i);
            List parents = this.selectionOperator.execute(matingPopulation);
            this.crossoverOperator.setCurrentSolution(matingPopulation.get(i));
            List children = this.crossoverOperator.execute(parents);
            offspringPopulation.add((DoubleSolution)children.get(0));
        }
        return offspringPopulation;
    }

    protected List<DoubleSolution> replacement(List<DoubleSolution> population, List<DoubleSolution> offspringPopulation) {
        ArrayList<DoubleSolution> pop = new ArrayList<DoubleSolution>();
        for (int i = 0; i < this.populationSize; ++i) {
            if (this.comparator.compare(population.get(i), offspringPopulation.get(i)) < 0) {
                pop.add(population.get(i));
                continue;
            }
            pop.add(offspringPopulation.get(i));
        }
        Collections.sort(pop, this.comparator);
        return pop;
    }

    public DoubleSolution getResult() {
        Collections.sort(this.getPopulation(), this.comparator);
        return (DoubleSolution)this.getPopulation().get(0);
    }
}

