/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.singleobjective.evolutionstrategy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.impl.AbstractEvolutionStrategy;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.comparator.ObjectiveComparator;

public class ElitistEvolutionStrategy<S extends Solution<?>>
extends AbstractEvolutionStrategy<S, S> {
    private Problem<S> problem;
    private int mu;
    private int lambda;
    private int maxEvaluations;
    private int evaluations;
    private MutationOperator<S> mutation;
    private Comparator<S> comparator;

    public ElitistEvolutionStrategy(Problem<S> problem, int mu, int lambda, int maxEvaluations, MutationOperator<S> mutation) {
        this.problem = problem;
        this.mu = mu;
        this.lambda = lambda;
        this.maxEvaluations = maxEvaluations;
        this.mutation = mutation;
        this.comparator = new ObjectiveComparator(0);
    }

    protected void initProgress() {
        this.evaluations = 1;
    }

    protected void updateProgress() {
        this.evaluations += this.lambda;
    }

    protected boolean isStoppingConditionReached() {
        return this.evaluations >= this.maxEvaluations;
    }

    protected List<S> createInitialPopulation() {
        ArrayList<Solution> population = new ArrayList<Solution>(this.mu);
        for (int i = 0; i < this.mu; ++i) {
            Solution newIndividual = this.problem.createSolution();
            population.add(newIndividual);
        }
        return population;
    }

    protected List<S> evaluatePopulation(List<S> population) {
        for (Solution solution : population) {
            this.problem.evaluate(solution);
        }
        return population;
    }

    protected List<S> selection(List<S> population) {
        return population;
    }

    protected List<S> reproduction(List<S> population) {
        ArrayList<Solution> offspringPopulation = new ArrayList<Solution>(this.lambda + this.mu);
        for (int i = 0; i < this.mu; ++i) {
            for (int j = 0; j < this.lambda / this.mu; ++j) {
                Solution offspring = ((Solution)population.get(i)).copy();
                this.mutation.execute((Object)offspring);
                offspringPopulation.add(offspring);
            }
        }
        return offspringPopulation;
    }

    protected List<S> replacement(List<S> population, List<S> offspringPopulation) {
        for (int i = 0; i < this.mu; ++i) {
            offspringPopulation.add(population.get(i));
        }
        Collections.sort(offspringPopulation, this.comparator);
        ArrayList<S> newPopulation = new ArrayList<S>(this.mu);
        for (int i = 0; i < this.mu; ++i) {
            newPopulation.add(offspringPopulation.get(i));
        }
        return newPopulation;
    }

    public S getResult() {
        return (S)((Solution)this.getPopulation().get(0));
    }
}

