/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.singleobjective.evolutionstrategy;

import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.singleobjective.evolutionstrategy.ElitistEvolutionStrategy;
import org.uma.jmetal.algorithm.singleobjective.evolutionstrategy.NonElitistEvolutionStrategy;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.AlgorithmBuilder;
import org.uma.jmetal.util.JMetalException;

public class EvolutionStrategyBuilder<S extends Solution<?>>
implements AlgorithmBuilder<Algorithm<S>> {
    private Problem<S> problem;
    private int mu;
    private int lambda;
    private int maxEvaluations;
    private MutationOperator<S> mutation;
    private EvolutionStrategyVariant variant;

    public EvolutionStrategyBuilder(Problem<S> problem, MutationOperator<S> mutationOperator, EvolutionStrategyVariant variant) {
        this.problem = problem;
        this.mu = 1;
        this.lambda = 10;
        this.maxEvaluations = 250000;
        this.mutation = mutationOperator;
        this.variant = variant;
    }

    public EvolutionStrategyBuilder<S> setMu(int mu) {
        this.mu = mu;
        return this;
    }

    public EvolutionStrategyBuilder<S> setLambda(int lambda) {
        this.lambda = lambda;
        return this;
    }

    public EvolutionStrategyBuilder<S> setMaxEvaluations(int maxEvaluations) {
        this.maxEvaluations = maxEvaluations;
        return this;
    }

    public Algorithm<S> build() {
        if (this.variant == EvolutionStrategyVariant.ELITIST) {
            return new ElitistEvolutionStrategy<S>(this.problem, this.mu, this.lambda, this.maxEvaluations, this.mutation);
        }
        if (this.variant == EvolutionStrategyVariant.NON_ELITIST) {
            return new NonElitistEvolutionStrategy<S>(this.problem, this.mu, this.lambda, this.maxEvaluations, this.mutation);
        }
        throw new JMetalException("Unknown variant: " + (Object)((Object)this.variant));
    }

    public int getMu() {
        return this.mu;
    }

    public int getLambda() {
        return this.lambda;
    }

    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    public MutationOperator<S> getMutation() {
        return this.mutation;
    }

    public static enum EvolutionStrategyVariant {
        ELITIST,
        NON_ELITIST;

    }
}

