/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.algorithm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.component.catalogue.common.evaluation.Evaluation;
import org.uma.jmetal.component.catalogue.common.solutionscreation.SolutionsCreation;
import org.uma.jmetal.component.catalogue.common.termination.Termination;
import org.uma.jmetal.component.catalogue.pso.globalbestinitialization.GlobalBestInitialization;
import org.uma.jmetal.component.catalogue.pso.globalbestselection.GlobalBestSelection;
import org.uma.jmetal.component.catalogue.pso.globalbestupdate.GlobalBestUpdate;
import org.uma.jmetal.component.catalogue.pso.inertiaweightcomputingstrategy.InertiaWeightComputingStrategy;
import org.uma.jmetal.component.catalogue.pso.localbestinitialization.LocalBestInitialization;
import org.uma.jmetal.component.catalogue.pso.localbestupdate.LocalBestUpdate;
import org.uma.jmetal.component.catalogue.pso.perturbation.Perturbation;
import org.uma.jmetal.component.catalogue.pso.positionupdate.PositionUpdate;
import org.uma.jmetal.component.catalogue.pso.velocityinitialization.VelocityInitialization;
import org.uma.jmetal.component.catalogue.pso.velocityupdate.VelocityUpdate;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.archive.BoundedArchive;
import org.uma.jmetal.util.observable.Observable;
import org.uma.jmetal.util.observable.ObservableEntity;
import org.uma.jmetal.util.observable.impl.DefaultObservable;

public class ParticleSwarmOptimizationAlgorithm
implements Algorithm<List<DoubleSolution>>,
ObservableEntity<Map<String, Object>> {
    private List<DoubleSolution> swarm;
    private double[][] speed;
    private DoubleSolution[] localBest;
    private BoundedArchive<DoubleSolution> globalBest;
    private Evaluation<DoubleSolution> evaluation;
    private SolutionsCreation<DoubleSolution> createInitialSwarm;
    private Termination termination;
    private VelocityInitialization velocityInitialization;
    private LocalBestInitialization localBestInitialization;
    private GlobalBestInitialization globalBestInitialization;
    private VelocityUpdate velocityUpdate;
    private PositionUpdate positionUpdate;
    private Perturbation perturbation;
    private GlobalBestUpdate globalBestUpdate;
    private LocalBestUpdate localBestUpdate;
    private InertiaWeightComputingStrategy inertiaWeightComputingStrategy;
    private GlobalBestSelection globalBestSelection;
    private Map<String, Object> attributes;
    private long initTime;
    private long totalComputingTime;
    private int evaluations;
    private Observable<Map<String, Object>> observable;
    private final String name;

    public ParticleSwarmOptimizationAlgorithm(String name, SolutionsCreation<DoubleSolution> createInitialSwarm, Evaluation<DoubleSolution> evaluation, Termination termination, VelocityInitialization velocityInitialization, LocalBestInitialization localBestInitialization, GlobalBestInitialization globalBestInitialization, InertiaWeightComputingStrategy inertiaWeightComputingStrategy, VelocityUpdate velocityUpdate, PositionUpdate positionUpdate, Perturbation perturbation, GlobalBestUpdate globalBestUpdate, LocalBestUpdate localBestUpdate, GlobalBestSelection globalBestSelection, BoundedArchive<DoubleSolution> globalBestArchive) {
        this.name = name;
        this.evaluation = evaluation;
        this.createInitialSwarm = createInitialSwarm;
        this.termination = termination;
        this.globalBest = globalBestArchive;
        this.velocityInitialization = velocityInitialization;
        this.localBestInitialization = localBestInitialization;
        this.globalBestInitialization = globalBestInitialization;
        this.inertiaWeightComputingStrategy = inertiaWeightComputingStrategy;
        this.velocityUpdate = velocityUpdate;
        this.positionUpdate = positionUpdate;
        this.perturbation = perturbation;
        this.globalBestUpdate = globalBestUpdate;
        this.localBestUpdate = localBestUpdate;
        this.globalBestSelection = globalBestSelection;
        this.observable = new DefaultObservable("Particle Swarm Optimization Algorithm");
        this.attributes = new HashMap<String, Object>();
    }

    public void run() {
        this.initTime = System.currentTimeMillis();
        this.swarm = this.createInitialSwarm.create();
        this.swarm = this.evaluation.evaluate(this.swarm);
        this.speed = this.velocityInitialization.initialize(this.swarm);
        this.localBest = this.localBestInitialization.initialize(this.swarm);
        this.globalBest = this.globalBestInitialization.initialize(this.swarm, this.globalBest);
        this.initProgress();
        while (!this.termination.isMet(this.attributes)) {
            this.speed = this.velocityUpdate.update(this.swarm, this.speed, this.localBest, this.globalBest, this.globalBestSelection, this.inertiaWeightComputingStrategy);
            this.swarm = this.positionUpdate.update(this.swarm, this.speed);
            this.swarm = this.perturbation.perturb(this.swarm);
            this.swarm = this.evaluation.evaluate(this.swarm);
            this.globalBest = this.globalBestUpdate.update(this.swarm, this.globalBest);
            this.localBest = this.localBestUpdate.update(this.swarm, this.localBest);
            this.updateProgress();
        }
        this.totalComputingTime = System.currentTimeMillis() - this.initTime;
    }

    protected void initProgress() {
        this.evaluations = this.swarm.size();
        this.globalBest.computeDensityEstimator();
        this.attributes.put("EVALUATIONS", this.evaluations);
        this.attributes.put("POPULATION", this.globalBest.solutions());
        this.attributes.put("COMPUTING_TIME", this.currentComputingTime());
    }

    protected void updateProgress() {
        this.evaluations += this.swarm.size();
        this.globalBest.computeDensityEstimator();
        this.attributes.put("EVALUATIONS", this.evaluations);
        this.attributes.put("POPULATION", this.globalBest.solutions());
        this.attributes.put("COMPUTING_TIME", this.currentComputingTime());
        this.observable.setChanged();
        this.observable.notifyObservers(this.attributes);
        this.totalComputingTime = this.currentComputingTime();
    }

    public long currentComputingTime() {
        return System.currentTimeMillis() - this.initTime;
    }

    public int numberOfEvaluations() {
        return this.evaluations;
    }

    public long totalComputingTime() {
        return this.totalComputingTime;
    }

    public List<DoubleSolution> result() {
        return this.globalBest.solutions();
    }

    public List<DoubleSolution> swarm() {
        return this.swarm;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return "Particle Swarm Optimization";
    }

    public Evaluation<DoubleSolution> evaluation() {
        return this.evaluation;
    }

    public Observable<Map<String, Object>> observable() {
        return this.observable;
    }

    public void termination(Termination termination) {
        this.termination = termination;
    }

    public void evaluation(Evaluation<DoubleSolution> evaluation) {
        this.evaluation = evaluation;
    }
}

