/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.algorithm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.component.catalogue.common.evaluation.Evaluation;
import org.uma.jmetal.component.catalogue.common.solutionscreation.SolutionsCreation;
import org.uma.jmetal.component.catalogue.common.termination.Termination;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.archive.Archive;
import org.uma.jmetal.util.archive.impl.NonDominatedSolutionListArchive;
import org.uma.jmetal.util.observable.Observable;
import org.uma.jmetal.util.observable.impl.DefaultObservable;

public class RandomSearchAlgorithm<S extends Solution<?>>
implements Algorithm<List<S>> {
    protected Termination termination;
    protected SolutionsCreation<S> solutionsCreation;
    protected Evaluation<S> evaluation;
    protected Map<String, Object> attributes;
    protected long initTime;
    protected long totalComputingTime;
    protected int evaluations;
    protected Observable<Map<String, Object>> observable;
    protected String name;
    protected NonDominatedSolutionListArchive<S> archive;
    private int evaluatedSolutions;

    public RandomSearchAlgorithm(String name, SolutionsCreation<S> solutionsCreation, Evaluation<S> evaluation, Termination termination) {
        this.name = name;
        this.termination = termination;
        this.solutionsCreation = solutionsCreation;
        this.evaluation = evaluation;
        this.observable = new DefaultObservable(name);
        this.attributes = new HashMap<String, Object>();
        this.archive = new NonDominatedSolutionListArchive();
    }

    public void run() {
        this.initTime = System.currentTimeMillis();
        this.initProgress();
        while (!this.termination.isMet(this.attributes)) {
            List<S> solutions = this.solutionsCreation.create();
            this.evaluation.evaluate(solutions);
            this.evaluatedSolutions = solutions.size();
            this.updateBestFoundSolutions(solutions);
            this.updateProgress();
        }
        this.totalComputingTime = System.currentTimeMillis() - this.initTime;
    }

    protected void initProgress() {
        this.evaluations = 0;
        this.attributes.put("EVALUATIONS", this.evaluations);
        this.attributes.put("COMPUTING_TIME", this.currentComputingTime());
        this.attributes.put("BEST_SOLUTIONS", this.archive.solutions());
        this.observable.setChanged();
        this.observable.notifyObservers(this.attributes);
    }

    protected void updateProgress() {
        this.evaluations += this.evaluatedSolutions;
        this.attributes.put("EVALUATIONS", this.evaluations);
        this.attributes.put("COMPUTING_TIME", this.currentComputingTime());
        this.attributes.put("BEST_SOLUTIONS", this.archive.solutions());
        this.observable.setChanged();
        this.observable.notifyObservers(this.attributes);
    }

    protected void updateBestFoundSolutions(List<S> solutions) {
        solutions.forEach(solution -> this.archive.add(solution));
    }

    protected List<S> bestSolutions() {
        return this.archive.solutions();
    }

    public List<S> result() {
        return this.archive.solutions();
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.name;
    }

    public int evaluations() {
        return this.evaluations;
    }

    public Archive<S> archive() {
        return this.archive;
    }

    public Observable<Map<String, Object>> getObservable() {
        return this.observable;
    }

    public Map<String, Object> attributes() {
        return this.attributes;
    }

    public long totalComputingTime() {
        return this.totalComputingTime;
    }

    public long currentComputingTime() {
        return System.currentTimeMillis() - this.initTime;
    }
}

